/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.util.ScreenCorner;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

public class WalletDisplayOverlay
implements IIngameOverlay {
    public static final WalletDisplayOverlay INSTANCE = new WalletDisplayOverlay();

    private WalletDisplayOverlay() {
    }

    public void render(ForgeIngameGui fgui, PoseStack pose, float partialTick, int screenWidth, int screenHeight) {
        ItemStack wallet;
        if (!((Boolean)Config.CLIENT.walletOverlayEnabled.get()).booleanValue()) {
            return;
        }
        EasyGuiGraphics gui = EasyGuiGraphics.create(pose, fgui.m_93082_(), 0, 0, partialTick);
        ScreenCorner corner = (ScreenCorner)((Object)Config.CLIENT.walletOverlayCorner.get());
        ScreenPosition offset = Config.CLIENT.walletOverlayPosition.get();
        ScreenPosition currentPosition = corner.getCorner(screenWidth, screenHeight).offset(offset);
        if (corner.isRightSide) {
            currentPosition = currentPosition.offset(ScreenPosition.of(-16, 0));
        }
        if (corner.isBottomSide) {
            currentPosition = currentPosition.offset(ScreenPosition.of(0, -16));
        }
        if (!(wallet = LightmansCurrency.getWalletStack((Player)Minecraft.m_91087_().f_91074_)).m_41619_()) {
            gui.renderItem(wallet, currentPosition.x, currentPosition.y);
            currentPosition = corner.isRightSide ? currentPosition.offset(ScreenPosition.of(-17, 0)) : currentPosition.offset(ScreenPosition.of(17, 0));
            CoinValue walletValue = MoneyUtil.getCoinValue(WalletItem.getWalletInventory(wallet));
            switch ((DisplayType)((Object)Config.CLIENT.walletOverlayType.get())) {
                case ITEMS_NARROW: 
                case ITEMS_WIDE: {
                    int offsetAmount = Config.CLIENT.walletOverlayType.get() == DisplayType.ITEMS_WIDE ? 17 : 9;
                    List<ItemStack> contents = walletValue.getAsItemList();
                    for (ItemStack coin : contents) {
                        gui.renderItem(coin, currentPosition.x, currentPosition.y);
                        if (corner.isRightSide) {
                            currentPosition = currentPosition.offset(ScreenPosition.of(-offsetAmount, 0));
                            continue;
                        }
                        currentPosition = currentPosition.offset(ScreenPosition.of(offsetAmount, 0));
                    }
                    break;
                }
                case TEXT: {
                    String valueString = walletValue.getString();
                    if (corner.isRightSide) {
                        gui.drawString(valueString, currentPosition.offset(-1 * gui.font.m_92895_(valueString), 3), 0xFFFFFF);
                        break;
                    }
                    gui.drawString(valueString, currentPosition.offset(0, 3), 0xFFFFFF);
                }
            }
        }
    }

    public static enum DisplayType {
        ITEMS_WIDE,
        ITEMS_NARROW,
        TEXT;

    }
}

