/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.NetworkTraderButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.TerminalMenu;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.sorting.TerminalSorter;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenTrades;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NetworkTerminalScreen
extends EasyMenuScreen<TerminalMenu>
implements IScrollable {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/trader_selection.png");
    private EditBox searchField;
    private static int scroll = 0;
    ScrollBarWidget scrollBar;
    List<NetworkTraderButton> traderButtons;
    private List<TraderData> filteredTraderList = new ArrayList<TraderData>();

    private List<TraderData> traderList() {
        List<TraderData> traderList = TraderSaveData.GetAllTerminalTraders(true);
        traderList.sort(TerminalSorter.getDefaultSorter());
        return traderList;
    }

    public NetworkTerminalScreen(TerminalMenu menu, Inventory inventory, Component ignored) {
        super(menu, inventory, (Component)EasyText.translatable("block.lightmanscurrency.terminal", new Object[0]));
        this.resize(176, 187);
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.searchField = this.addChild(new EditBox(this.f_96547_, screenArea.x + 28, screenArea.y + 6, 101, 9, this.searchField, (Component)EasyText.translatable("gui.lightmanscurrency.terminal.search", new Object[0])));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(0xFFFFFF);
        this.searchField.m_94151_(this::updateTraderList);
        this.scrollBar = this.addChild(new ScrollBarWidget(screenArea.pos.offset(162, 17), 152, this));
        this.initTraderButtons(screenArea);
        this.m_96624_();
        this.updateTraderList(this.searchField.m_94155_());
        this.validateScroll();
    }

    private void initTraderButtons(ScreenArea screenArea) {
        this.traderButtons = new ArrayList<NetworkTraderButton>();
        for (int y = 0; y < 5; ++y) {
            NetworkTraderButton newButton = this.addChild(new NetworkTraderButton(screenArea.pos.offset(15, 18 + y * 30), this::OpenTrader));
            this.traderButtons.add(newButton);
        }
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.renderNormalBackground(GUI_TEXTURE, this);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.handleScrollWheel(delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void OpenTrader(EasyButton button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            new CPacketOpenTrades(this.filteredTraderList.get(index).getID()).send();
        }
    }

    private int getTraderIndex(EasyButton button) {
        if (button instanceof NetworkTraderButton && this.traderButtons.contains((Object)button)) {
            return this.traderButtons.indexOf((Object)button) + scroll;
        }
        return -1;
    }

    private void updateTraderList(String searchString) {
        this.filteredTraderList = searchString.isBlank() ? this.traderList() : TraderSearchFilter.FilterTraders(this.traderList(), searchString);
        this.validateScroll();
        this.updateTraderButtons();
    }

    private void updateTraderButtons() {
        int startIndex = scroll;
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    @Override
    public int currentScroll() {
        return scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        scroll = newScroll;
        this.updateTraderButtons();
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.filteredTraderList.size() - this.traderButtons.size());
    }
}

