/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.TicketMachineMenu;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.common.util.NonNullSupplier;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class TicketMachineScreen
extends EasyMenuScreen<TicketMachineMenu> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/ticket_machine.png");
    public static final Sprite SPRITE_ARROW = Sprite.SimpleSprite(GUI_TEXTURE, 176, 0, 24, 16);
    private PlainButton buttonTogglePass;
    private boolean craftPass = false;

    public TicketMachineScreen(TicketMachineMenu container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.resize(176, 138);
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.renderNormalBackground(GUI_TEXTURE, this);
        gui.drawString(this.f_96539_, 8, 6, 0x404040);
        gui.drawString(this.f_169604_, 8, this.getYSize() - 94, 0x404040);
        if (this.buttonTogglePass.f_93624_) {
            int textWidth = gui.font.m_92852_((FormattedText)EasyText.translatable("gui.button.lightmanscurrency.craft_pass.option", new Object[0]));
            gui.drawString((Component)EasyText.translatable("gui.button.lightmanscurrency.craft_pass.option", new Object[0]), this.getXSize() - 14 - textWidth, 6, 0x404040);
        }
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.addChild(new PlainButton(screenArea.x + 79, screenArea.y + 21, this::craftTicket, SPRITE_ARROW).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> ((TicketMachineMenu)this.f_97732_).validInputs() && ((TicketMachineMenu)this.f_97732_).roomForOutput(this.craftPass))), EasyAddonHelper.tooltip(this::getArrowTooltip)));
        WidgetAddon[] widgetAddonArray = new WidgetAddon[1];
        widgetAddonArray[0] = EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)((TicketMachineMenu)this.f_97732_)::hasMasterTicket));
        this.buttonTogglePass = this.addChild(IconAndButtonUtil.checkmarkButton(screenArea.x + screenArea.width - 14, screenArea.y + 5, this::togglePassCraft, (NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.craftPass)).withAddons(widgetAddonArray));
    }

    private Component getArrowTooltip() {
        if (((TicketMachineMenu)this.f_97732_).hasMasterTicket()) {
            return this.craftPass ? EasyText.translatable("gui.button.lightmanscurrency.craft_pass", new Object[0]) : EasyText.translatable("gui.button.lightmanscurrency.craft_ticket", new Object[0]);
        }
        return EasyText.translatable("gui.button.lightmanscurrency.craft_master_ticket", new Object[0]);
    }

    private void togglePassCraft(EasyButton button) {
        this.craftPass = !this.craftPass;
    }

    private void craftTicket(EasyButton button) {
        ((TicketMachineMenu)this.f_97732_).SendCraftTicketsMessage(Screen.m_96638_(), this.craftPass);
    }
}

