/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.BankAccountWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.ATMMenu;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;

public class InteractionTab
extends ATMTab
implements BankAccountWidget.IBankAccountWidget {
    BankAccountWidget accountWidget;

    public InteractionTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModBlocks.COINPILE_GOLD);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.atm.interact", new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.accountWidget = this.addChild(new BankAccountWidget(screenArea.y, this, 14, this::addChild));
        this.accountWidget.getAmountSelection().drawBG = false;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        MutableComponent accountName = EasyText.literal("ERROR FINDING ACCOUNT");
        BankAccount account = this.getBankAccount();
        if (account != null) {
            accountName = account.getName();
        }
        gui.drawString((Component)accountName, 8, 75, 0x404040);
        this.accountWidget.renderInfo(gui);
    }

    @Override
    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public BankAccount getBankAccount() {
        return ((ATMMenu)this.screen.m_6262_()).getBankAccount();
    }

    @Override
    public Container getCoinAccess() {
        return ((ATMMenu)this.screen.m_6262_()).getCoinInput();
    }
}

