/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class NotificationTab
extends ATMTab {
    CoinValueInput notificationSelection;

    public NotificationTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42584_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.atm.notification", new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        SimpleSlot.SetInactive(this.screen.m_6262_());
        Component accountName = ((ATMMenu)this.screen.m_6262_()).getPlayer().m_5446_();
        if (((ATMMenu)this.screen.m_6262_()).getBankAccount() != null) {
            accountName = ((ATMMenu)this.screen.m_6262_()).getBankAccount().getName();
        }
        this.notificationSelection = this.addChild(new CoinValueInput(screenArea.x, screenArea.y, accountName, ((ATMMenu)this.screen.m_6262_()).getBankAccount().getNotificationValue(), this.screen.getFont(), this::onValueChanged));
        this.notificationSelection.drawBG = false;
        this.notificationSelection.allowFreeToggle = false;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.hideCoinSlots(gui);
        BankAccount account = ((ATMMenu)this.screen.m_6262_()).getBankAccount();
        if (account != null) {
            TextRenderUtil.drawCenteredMultilineText(gui, (Component)(account.getNotificationLevel() > 0L ? EasyText.translatable("gui.lightmanscurrency.notification.details", account.getNotificationValue().getString()) : EasyText.translatable("gui.lightmanscurrency.notification.disabled", new Object[0])), 5, this.screen.getXSize() - 10, 70, 0x404040);
        }
    }

    @Override
    protected void closeAction() {
        SimpleSlot.SetActive(this.screen.m_6262_());
    }

    public void onValueChanged(CoinValue value) {
        ((ATMMenu)this.screen.m_6262_()).SetNotificationValueAndUpdate(value);
    }
}

