/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.TeamBankReference;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketATMSetPlayerAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketSelectBankAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SelectionTab
extends ATMTab {
    EasyButton buttonPersonalAccount;
    TeamSelectWidget teamSelection;
    EasyButton buttonToggleAdminMode;
    EditBox playerAccountSelect;
    EasyButton buttonSelectPlayerAccount;
    MutableComponent responseMessage = EasyText.empty();
    boolean adminMode = false;

    public SelectionTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42516_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.atm.selection", new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.adminMode = false;
        if (firstOpen) {
            this.responseMessage = EasyText.empty();
        }
        SimpleSlot.SetInactive(this.screen.m_6262_());
        this.teamSelection = this.addChild(new TeamSelectWidget(screenArea.pos.offset(79, 15), 6, TeamButton.Size.NARROW, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.buttonPersonalAccount = this.addChild(new EasyTextButton(screenArea.pos.offset(7, 15), 70, 20, (Component)EasyText.translatable("gui.button.bank.playeraccount", new Object[0]), this::PressPersonalAccount));
        this.buttonToggleAdminMode = this.addChild(new IconButton(screenArea.pos.offset(screenArea.width, 0), this::ToggleAdminMode, IconData.of((ItemLike)Items.f_42116_)));
        this.buttonToggleAdminMode.f_93624_ = LCAdminMode.isAdminPlayer(((ATMMenu)this.screen.m_6262_()).getPlayer());
        this.playerAccountSelect = this.addChild(new EditBox(this.screen.getFont(), screenArea.x + 7, screenArea.y + 20, 162, 20, (Component)EasyText.empty()));
        this.playerAccountSelect.f_93624_ = false;
        this.buttonSelectPlayerAccount = this.addChild(new EasyTextButton(screenArea.pos.offset(7, 45), 162, 20, (Component)EasyText.translatable("gui.button.bank.admin.playeraccount", new Object[0]), this::PressSelectPlayerAccount));
        this.buttonSelectPlayerAccount.f_93624_ = false;
        this.tick();
    }

    private BankReference getBankReference() {
        return ((ATMMenu)this.screen.m_6262_()).getBankAccountReference();
    }

    private boolean isSelfSelected() {
        return ((ATMMenu)this.screen.m_6262_()).getBankAccount() == PlayerBankReference.of(((ATMMenu)this.screen.m_6262_()).getPlayer()).get();
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        for (Team team : TeamSaveData.GetAllTeams(true)) {
            if (!team.hasBankAccount() || !team.canAccessBankAccount(((ATMMenu)this.screen.m_6262_()).getPlayer())) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        BankReference bankReference = this.getBankReference();
        if (bankReference instanceof TeamBankReference) {
            TeamBankReference teamBankReference = (TeamBankReference)bankReference;
            return TeamSaveData.GetTeam(true, teamBankReference.teamID);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            Team selectedTeam = this.selectedTeam();
            if (selectedTeam != null && team.getID() == selectedTeam.getID()) {
                return;
            }
            BankReference account = TeamBankReference.of(team).flagAsClient();
            new CPacketSelectBankAccount(account).send();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void PressPersonalAccount(EasyButton button) {
        BankReference account = PlayerBankReference.of(((ATMMenu)this.screen.m_6262_()).getPlayer());
        new CPacketSelectBankAccount(account).send();
    }

    private void ToggleAdminMode(EasyButton button) {
        this.adminMode = !this.adminMode;
        this.buttonPersonalAccount.f_93624_ = !this.adminMode;
        this.teamSelection.f_93624_ = !this.adminMode;
        this.buttonSelectPlayerAccount.f_93624_ = this.adminMode;
        this.playerAccountSelect.f_93624_ = this.adminMode;
    }

    private void PressSelectPlayerAccount(EasyButton button) {
        String playerName = this.playerAccountSelect.m_94155_();
        this.playerAccountSelect.m_94144_("");
        if (!playerName.isBlank()) {
            new CPacketATMSetPlayerAccount(playerName).send();
        }
    }

    public void ReceiveSelectPlayerResponse(MutableComponent message) {
        this.responseMessage = message;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.hideCoinSlots(gui);
        gui.drawString((Component)this.getTooltip(), 8, 6, 0x404040);
        if (this.adminMode) {
            List lines = this.screen.getFont().m_92865_().m_92414_((FormattedText)this.responseMessage, this.screen.getXSize() - 15, Style.f_131099_);
            for (int i = 0; i < lines.size(); ++i) {
                String string = ((FormattedText)lines.get(i)).getString();
                Objects.requireNonNull(gui.font);
                gui.drawString(string, 7, 70 + 9 * i, 0x404040);
            }
        }
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        if (this.getTeamList().size() == 0 && !this.adminMode) {
            gui.pushOffsetZero();
            TextRenderUtil.drawVerticallyCenteredMultilineText(gui, (Component)EasyText.translatable("gui.lightmanscurrency.bank.noteamsavailable", new Object[0]), this.teamSelection.getX() + 1, TeamButton.Size.NARROW.width - 2, this.teamSelection.getY() + 1, this.teamSelection.m_93694_() - 2, 0xFFFFFF);
            gui.popOffset();
        }
    }

    @Override
    public void tick() {
        this.buttonPersonalAccount.f_93623_ = !this.isSelfSelected();
        this.buttonToggleAdminMode.f_93624_ = LCAdminMode.isAdminPlayer(((ATMMenu)this.screen.m_6262_()).getPlayer());
        if (this.adminMode) {
            this.playerAccountSelect.m_94120_();
        }
    }

    @Override
    public void closeAction() {
        SimpleSlot.SetActive(this.screen.m_6262_());
    }
}

