/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest.CoinChestTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm.ATMExchangeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.atm.ATMData;
import io.github.lightman314.lightmanscurrency.common.atm.ATMExchangeButtonData;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestExchangeUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.util.NonNullSupplier;

public class ExchangeUpgradeTab
extends CoinChestTab.Upgrade {
    List<ATMExchangeButton> buttons = new ArrayList<ATMExchangeButton>();
    EasyButton exchangeWhileOpenButton;

    public ExchangeUpgradeTab(CoinChestUpgradeData data, Object screen) {
        super(data, screen);
    }

    @Override
    public boolean coinSlotsVisible() {
        return false;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.buttons = new ArrayList<ATMExchangeButton>();
        List<ATMExchangeButtonData> buttonData = ATMData.get().getConversionButtons();
        for (ATMExchangeButtonData data : buttonData) {
            this.buttons.add(this.addChild(new ATMExchangeButton(screenArea.pos, data, this::SelectNewCommand)));
        }
        this.exchangeWhileOpenButton = this.addChild(new EasyTextButton(screenArea.pos.offset(10, 124), screenArea.width - 20, 20, (NonNullSupplier<Component>)((NonNullSupplier)this::GetExchangeWhileOpenText), this::ToggleExchangeWhileOpen));
        this.tick();
    }

    private void updateSelectedButton() {
        CoinChestUpgradeData data = this.getUpgradeData();
        String currentCommand = data == null ? "" : UpgradeType.COIN_CHEST_EXCHANGE.getExchangeCommand(data);
        for (ATMExchangeButton button : this.buttons) {
            button.selected = Objects.equals(button.data.command, currentCommand);
        }
    }

    private void SelectNewCommand(String command) {
        ((CoinChestMenu)this.screen.m_6262_()).SendMessageToServer(LazyPacketData.builder().setString("SetExchangeCommand", command));
    }

    private void ToggleExchangeWhileOpen(EasyButton button) {
        CoinChestExchangeUpgrade upgrade;
        CoinChestUpgrade coinChestUpgrade;
        CoinChestUpgradeData data = this.getUpgradeData();
        boolean currentState = data != null && (coinChestUpgrade = data.upgrade) instanceof CoinChestExchangeUpgrade && (upgrade = (CoinChestExchangeUpgrade)coinChestUpgrade).getExchangeWhileOpen(data);
        ((CoinChestMenu)this.screen.m_6262_()).SendMessageToServer(LazyPacketData.builder().setBoolean("SetExchangeWhileOpen", !currentState));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }

    @Override
    public void tick() {
        this.updateSelectedButton();
    }

    private Component GetExchangeWhileOpenText() {
        CoinChestUpgradeData data = this.getUpgradeData();
        if (data != null) {
            return EasyText.translatable("button.lightmanscurrency.upgrade.coin_chest.exchange.while_open." + (UpgradeType.COIN_CHEST_EXCHANGE.getExchangeWhileOpen(data) ? "y" : "n"), new Object[0]);
        }
        return EasyText.empty();
    }
}

