/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest.CoinChestTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.ownership.OwnerData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestSecurityUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class SecurityUpgradeTab
extends CoinChestTab.Upgrade {
    EditBox newOwnerInput;
    EasyButton buttonSetOwner;
    TeamSelectWidget teamSelection;
    EasyButton buttonSetTeamOwner;
    long selectedTeam = -1L;
    List<Team> teamList = Lists.newArrayList();
    IconButton buttonSetSelfOwner;

    public SecurityUpgradeTab(CoinChestUpgradeData data, Object screen) {
        super(data, screen);
    }

    @Override
    public boolean isVisible() {
        CoinChestUpgrade coinChestUpgrade;
        CoinChestUpgradeData data = this.getUpgradeData();
        if (data != null && (coinChestUpgrade = data.upgrade) instanceof CoinChestSecurityUpgrade) {
            CoinChestSecurityUpgrade upgrade = (CoinChestSecurityUpgrade)coinChestUpgrade;
            return upgrade.isAdmin(this.screen.be, data, ((CoinChestMenu)this.screen.m_6262_()).player);
        }
        return false;
    }

    @Override
    public boolean coinSlotsVisible() {
        return false;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public boolean titleVisible() {
        return false;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.newOwnerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 18, this.screen.getXSize() - 20, 20, (Component)EasyText.empty()));
        this.newOwnerInput.m_94199_(16);
        this.buttonSetOwner = this.addChild(new EasyTextButton(screenArea.pos.offset(10, 39), screenArea.width - 20, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.set_owner", new Object[0]), this::setOwner).withAddons(EasyAddonHelper.tooltip(IconAndButtonUtil.TOOLTIP_CANNOT_BE_UNDONE)));
        this.buttonSetOwner.f_93623_ = false;
        this.teamSelection = this.addChild(new TeamSelectWidget(screenArea.pos.offset(10, 63), 3, TeamButton.Size.NORMAL, () -> this.teamList, this::getSelectedTeam, this::selectTeam));
        this.buttonSetTeamOwner = this.addChild(new EasyTextButton(screenArea.pos.offset(10, 124), screenArea.width - 20, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.set_owner", new Object[0]), this::setTeamOwner).withAddons(EasyAddonHelper.tooltip(IconAndButtonUtil.TOOLTIP_CANNOT_BE_UNDONE)));
        this.buttonSetTeamOwner.f_93623_ = false;
        this.buttonSetSelfOwner = this.addChild(new IconButton(this.screen.getGuiLeft() + this.screen.getXSize() - 20 - 3, this.screen.getGuiTop() + 3, this::setSelfOwner, IconAndButtonUtil.ICON_ALEX_HEAD).withAddons(EasyAddonHelper.tooltip((Component)EasyText.translatable("tooltip.lightmanscurrency.settings.owner.self", new Object[0]))));
        this.tick();
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private Team getSelectedTeam() {
        if (this.selectedTeam < 0L) {
            return null;
        }
        return TeamSaveData.GetTeam(true, this.selectedTeam);
    }

    private void refreshTeamList() {
        this.teamList = Lists.newArrayList();
        List<Team> allTeams = TeamSaveData.GetAllTeams(true);
        allTeams.forEach(team -> {
            if (team.isMember(this.menu.player)) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.menu.player));
    }

    private Component getOwnerName() {
        CoinChestUpgrade coinChestUpgrade;
        CoinChestUpgradeData data = this.getUpgradeData();
        if (data != null && (coinChestUpgrade = data.upgrade) instanceof CoinChestSecurityUpgrade) {
            CoinChestSecurityUpgrade upgrade = (CoinChestSecurityUpgrade)coinChestUpgrade;
            return EasyText.literal(upgrade.parseOwnerData(this.menu.be, data).getOwnerName(true));
        }
        return EasyText.translatable("gui.button.lightmanscurrency.team.owner.null", new Object[0]);
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString(TextRenderUtil.fitString((Component)EasyText.translatable("gui.button.lightmanscurrency.team.owner", this.getOwnerName()), this.screen.getXSize() - 20), 8, 6, 0x404040);
    }

    private void setSelfOwner(EasyButton button) {
        this.menu.SendMessageToServer(LazyPacketData.builder().setBoolean("SetSelfOwner", true));
    }

    private void setOwner(EasyButton button) {
        if (this.newOwnerInput.m_94155_().isBlank()) {
            return;
        }
        this.menu.SendMessageToServer(LazyPacketData.builder().setString("SetPlayerOwner", this.newOwnerInput.m_94155_()));
        this.newOwnerInput.m_94144_("");
    }

    private void setTeamOwner(EasyButton button) {
        if (this.selectedTeam < 0L) {
            return;
        }
        this.menu.SendMessageToServer(LazyPacketData.builder().setLong("SetTeamOwner", this.selectedTeam));
        this.selectedTeam = -1L;
    }

    private void selectTeam(int teamIndex) {
        Team newTeam = this.getTeam(teamIndex);
        if (newTeam != null) {
            this.selectedTeam = newTeam.getID() == this.selectedTeam ? -1L : newTeam.getID();
        }
    }

    @Override
    public void tick() {
        CoinChestSecurityUpgrade upgrade;
        OwnerData owner;
        CoinChestUpgrade coinChestUpgrade;
        this.refreshTeamList();
        this.buttonSetOwner.f_93623_ = !this.newOwnerInput.m_94155_().isBlank();
        this.buttonSetTeamOwner.f_93623_ = this.getSelectedTeam() != null;
        CoinChestUpgradeData data = this.getUpgradeData();
        this.buttonSetSelfOwner.f_93624_ = data != null && (coinChestUpgrade = data.upgrade) instanceof CoinChestSecurityUpgrade ? !(owner = (upgrade = (CoinChestSecurityUpgrade)coinChestUpgrade).parseOwnerData(this.menu.be, data)).hasOwner() || owner.hasTeam() || !owner.getPlayer().is((Entity)this.menu.player) : false;
    }

    @Override
    public void closeAction() {
        this.selectedTeam = -1L;
        this.teamList = new ArrayList<Team>();
    }
}

