/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.tax_collector;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.TaxCollectorClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.tabs.BasicSettingsTab;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class BasicSettingsClientTab
extends TaxCollectorClientTab<BasicSettingsTab> {
    private EditBox nameInput;
    private boolean showAreaButtons = true;

    public BasicSettingsClientTab(Object screen, BasicSettingsTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TAXES;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return EasyText.translatable("gui.lightmanscurrency.tax_collector.basic", new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        TaxEntry entry = this.getEntry();
        this.addChild(IconAndButtonUtil.checkmarkButton(screenArea.pos.offset(8, 16), this::ToggleActiveState, (NonNullSupplier<Boolean>)((NonNullSupplier)this::isEntryActive)).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::canActiveToggle))));
        this.addChild(new DropdownWidget(screenArea.pos.offset(screenArea.width - 88, 26), 80, entry == null ? 0 : entry.getRenderMode(), ((BasicSettingsTab)this.commonTab)::SetRenderMode, new Component[]{EasyText.translatable("gui.lightmanscurrency.tax_collector.render_mode.0", new Object[0]), EasyText.translatable("gui.lightmanscurrency.tax_collector.render_mode.1", new Object[0]), EasyText.translatable("gui.lightmanscurrency.tax_collector.render_mode.2", new Object[0])}).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::showAreaButtons))));
        this.addChild(IconAndButtonUtil.plusButton(screenArea.pos.offset(6, 32), b -> ((BasicSettingsTab)this.commonTab).SetRate(this.getCurrentRate() + (Screen.m_96638_() ? 10 : 1))).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getTaxRate() < TaxEntry.maxTaxRate();
        }))));
        this.addChild(IconAndButtonUtil.minusButton(screenArea.pos.offset(6, 42), b -> ((BasicSettingsTab)this.commonTab).SetRate(this.getCurrentRate() - (Screen.m_96638_() ? 10 : 1))).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getTaxRate() > 1;
        }))));
        this.addChild(IconAndButtonUtil.plusButton(screenArea.pos.offset(22, screenArea.height - 16), b -> ((BasicSettingsTab)this.commonTab).SetRadius(this.getCurrentRadius() + (Screen.m_96638_() ? 10 : 1))).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::showAreaButtons))).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getRadius() < TaxEntry.maxRadius();
        }))));
        this.addChild(IconAndButtonUtil.minusButton(screenArea.pos.offset(32, screenArea.height - 16), b -> ((BasicSettingsTab)this.commonTab).SetRadius(this.getCurrentRadius() - (Screen.m_96638_() ? 10 : 1))).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::showAreaButtons))).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getRadius() > TaxEntry.minRadius();
        }))));
        this.addChild(IconAndButtonUtil.plusButton(screenArea.pos.offset(screenArea.width / 2 - 10, screenArea.height - 16), b -> ((BasicSettingsTab)this.commonTab).SetHeight(this.getCurrentHeight() + (Screen.m_96638_() ? 10 : 1))).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::showAreaButtons))).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getHeight() < TaxEntry.maxHeight();
        }))));
        this.addChild(IconAndButtonUtil.minusButton(screenArea.pos.offset(screenArea.width / 2, screenArea.height - 16), b -> ((BasicSettingsTab)this.commonTab).SetHeight(this.getCurrentHeight() - (Screen.m_96638_() ? 10 : 1))).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::showAreaButtons))).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getHeight() > TaxEntry.minHeight();
        }))));
        this.addChild(IconAndButtonUtil.plusButton(screenArea.pos.offset(screenArea.width - 42, screenArea.height - 16), b -> ((BasicSettingsTab)this.commonTab).SetVertOffset(this.getCurrentVertOffset() + (Screen.m_96638_() ? 10 : 1))).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::showAreaButtons))).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getVertOffset() < TaxEntry.maxVertOffset();
        }))));
        this.addChild(IconAndButtonUtil.minusButton(screenArea.pos.offset(screenArea.width - 32, screenArea.height - 16), b -> ((BasicSettingsTab)this.commonTab).SetVertOffset(this.getCurrentVertOffset() - (Screen.m_96638_() ? 10 : 1))).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::showAreaButtons))).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getVertOffset() > TaxEntry.minVertOffset();
        }))));
        this.addChild(IconAndButtonUtil.checkmarkButton(screenArea.pos.offset(8, 58), b -> ((BasicSettingsTab)this.commonTab).SetBankAccountLink(!this.getCurrentBankAccountLink()), (NonNullSupplier<Boolean>)((NonNullSupplier)this::getCurrentBankAccountLink)).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> !this.menu.isServerEntry()))));
        this.nameInput = this.addChild(new EditBox(this.getFont(), screenArea.pos.x + 10, screenArea.pos.y + 80, screenArea.width - 20, 18, (Component)EasyText.empty()));
        this.nameInput.m_94144_(entry != null ? entry.getCustomName() : "");
        this.addChild(new EasyTextButton(screenArea.pos.offset(10, 102), 70, 20, (Component)EasyText.translatable("gui.lightmanscurrency.changename", new Object[0]), () -> ((BasicSettingsTab)this.commonTab).SetName(this.getCurrentNameInput())).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::isNameDifferent))));
        this.addChild(new EasyTextButton(screenArea.pos.offset(96, 102), 70, 20, (Component)EasyText.translatable("gui.lightmanscurrency.resetname", new Object[0]), this::ResetName).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::hasCustomName))));
        this.tick();
    }

    @Override
    public void tick() {
        TaxEntry entry = this.getEntry();
        this.showAreaButtons = entry != null && !entry.isInfiniteRange();
    }

    private boolean isEntryActive() {
        TaxEntry entry = this.getEntry();
        return entry != null && entry.isActive();
    }

    private boolean canActiveToggle() {
        TaxEntry entry = this.getEntry();
        return entry != null && ((Boolean)Config.SERVER.taxMachinesAdminOnly.get() == false || this.menu.isAdmin() || entry.isActive());
    }

    private boolean showAreaButtons() {
        return this.showAreaButtons;
    }

    private int getCurrentRate() {
        TaxEntry entry = this.getEntry();
        return entry != null ? entry.getTaxRate() : 0;
    }

    private int getCurrentRadius() {
        TaxEntry entry = this.getEntry();
        return entry != null ? entry.getRadius() : 0;
    }

    private int getCurrentHeight() {
        TaxEntry entry = this.getEntry();
        return entry != null ? entry.getHeight() : 0;
    }

    private int getCurrentVertOffset() {
        TaxEntry entry = this.getEntry();
        return entry != null ? entry.getVertOffset() : 0;
    }

    private boolean getCurrentBankAccountLink() {
        TaxEntry entry = this.getEntry();
        return entry != null && entry.isLinkedToBank();
    }

    private String getCurrentNameInput() {
        if (this.nameInput == null) {
            return "";
        }
        return this.nameInput.m_94155_();
    }

    private boolean isNameDifferent() {
        TaxEntry entry = this.getEntry();
        if (entry != null) {
            return !entry.getCustomName().equals(this.getCurrentNameInput());
        }
        return false;
    }

    private boolean hasCustomName() {
        TaxEntry entry = this.getEntry();
        if (entry != null) {
            return !entry.getCustomName().isBlank();
        }
        return false;
    }

    private void ResetName() {
        ((BasicSettingsTab)this.commonTab).SetName("");
        this.nameInput.m_94144_("");
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TaxEntry entry = this.getEntry();
        if (entry == null) {
            return;
        }
        gui.drawString((Component)entry.getName(), 8, 6, 0x404040);
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.tax_collector.active", new Object[0]), 20, 18, entry != null && entry.isActive() ? 65280 : 0xFF0000);
        if (this.showAreaButtons) {
            MutableComponent label = EasyText.translatable("gui.lightmanscurrency.tax_collector.render_mode.label", new Object[0]);
            gui.drawString((Component)label, this.screen.getXSize() - 8 - gui.font.m_92852_((FormattedText)label), 16, 0x404040);
        }
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.tax_collector.tax_rate", entry != null ? Integer.valueOf(entry.getTaxRate()) : "ERROR"), 18, 39, 0x404040);
        if (!entry.isServerEntry()) {
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.banklink", new Object[0]), 20, 60, 0x404040);
        }
        if (entry.isInfiniteRange()) {
            TextRenderUtil.drawCenteredText(gui, (Component)EasyText.translatable("gui.lightmanscurrency.tax_collector.area.infinite.label", new Object[0]), this.screen.getXSize() / 2, this.screen.getYSize() - 38, 0x404040);
            MutableComponent areaText = entry.getCenter().isVoid() ? EasyText.translatable("gui.lightmanscurrency.tax_collector.area.infinite.void", new Object[0]) : EasyText.translatable("gui.lightmanscurrency.tax_collector.area.infinite.dimension", entry.getCenter().getDimension().m_135782_());
            TextRenderUtil.drawCenteredText(gui, (Component)areaText, this.screen.getXSize() / 2, this.screen.getYSize() - 28, 0x404040);
        } else {
            TextRenderUtil.drawCenteredText(gui, (Component)EasyText.translatable("gui.lightmanscurrency.tax_collector.area.radius", new Object[0]), 32, this.screen.getYSize() - 38, 0x404040);
            TextRenderUtil.drawCenteredText(gui, Integer.toString(entry.getRadius()), 32, this.screen.getYSize() - 28, 0x404040);
            TextRenderUtil.drawCenteredText(gui, (Component)EasyText.translatable("gui.lightmanscurrency.tax_collector.area.height", new Object[0]), this.screen.getXSize() / 2, this.screen.getYSize() - 38, 0x404040);
            TextRenderUtil.drawCenteredText(gui, Integer.toString(entry.getHeight()), this.screen.getXSize() / 2, this.screen.getYSize() - 28, 0x404040);
            TextRenderUtil.drawCenteredText(gui, (Component)EasyText.translatable("gui.lightmanscurrency.tax_collector.area.vertOffset", new Object[0]), this.screen.getXSize() - 32, this.screen.getYSize() - 38, 0x404040);
            TextRenderUtil.drawCenteredText(gui, Integer.toString(entry.getVertOffset()), this.screen.getXSize() - 32, this.screen.getYSize() - 28, 0x404040);
        }
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.nameInput.m_93696_();
    }

    private void ToggleActiveState(EasyButton button) {
        ((BasicSettingsTab)this.commonTab).SetActive(!this.isEntryActive());
    }
}

