/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.InfoTab;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison.TradeComparisonResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class InfoClientTab
extends TraderInterfaceClientTab<InfoTab> {
    TradeButton tradeDisplay;
    TradeButton newTradeDisplay;
    DropdownWidget interactionDropdown;
    EasyButton acceptChangesButton;
    private final ScreenArea WARNING_AREA = ScreenArea.of(45, 69, 16, 16);

    public InfoClientTab(TraderInterfaceScreen screen, InfoTab tab) {
        super(screen, tab);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42516_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.interface.info", new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.tradeDisplay = this.addChild(new TradeButton(this.menu::getTradeContext, ((TraderInterfaceMenu)this.screen.m_6262_()).getBE()::getReferencedTrade, (Consumer<EasyButton>)TradeButton.NULL_PRESS));
        this.tradeDisplay.setPosition(screenArea.pos.offset(6, 47));
        this.tradeDisplay.displayOnly = true;
        this.newTradeDisplay = this.addChild(new TradeButton(this.menu::getTradeContext, ((TraderInterfaceMenu)this.screen.m_6262_()).getBE()::getTrueTrade, (Consumer<EasyButton>)TradeButton.NULL_PRESS));
        this.newTradeDisplay.setPosition(screenArea.pos.offset(6, 91));
        this.newTradeDisplay.f_93624_ = false;
        this.newTradeDisplay.displayOnly = true;
        this.interactionDropdown = this.addChild(IconAndButtonUtil.interactionTypeDropdown(screenArea.pos.offset(104, 25), 97, ((TraderInterfaceMenu)this.screen.m_6262_()).getBE().getInteractionType(), this::onInteractionSelect, this.menu.getBE().getBlacklistedInteractions()));
        this.acceptChangesButton = this.addChild(new IconButton(screenArea.pos.offset(181, 90), this::AcceptTradeChanges, IconAndButtonUtil.ICON_CHECKMARK).withAddons(EasyAddonHelper.tooltip((Component)EasyText.translatable("tooltip.lightmanscurrency.interface.info.acceptchanges", new Object[0]))));
        this.acceptChangesButton.f_93624_ = false;
    }

    private List<Component> getWarningMessages() {
        TraderData trader;
        if (this.menu.getBE() == null) {
            return new ArrayList<Component>();
        }
        ArrayList<Component> list = new ArrayList<Component>();
        TradeContext.TradeResult result = this.menu.getBE().mostRecentTradeResult();
        if (result.failMessage != null) {
            list.add(result.failMessage);
        }
        if (this.menu.getBE().getInteractionType().trades) {
            TradeData referencedTrade = this.menu.getBE().getReferencedTrade();
            TradeData trueTrade = this.menu.getBE().getTrueTrade();
            if (referencedTrade == null) {
                return new ArrayList<Component>();
            }
            if (trueTrade == null) {
                list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.difference.missing", new Object[0]).m_130940_(ChatFormatting.RED));
                return list;
            }
            TradeComparisonResult differences = referencedTrade.compare(trueTrade);
            if (!differences.TypeMatches()) {
                list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.difference.type", new Object[0]).m_130940_(ChatFormatting.RED));
                return list;
            }
            list.addAll(referencedTrade.GetDifferenceWarnings(differences));
            return list;
        }
        if (this.menu.getBE().getInteractionType().requiresPermissions && (trader = this.menu.getBE().getTrader()) != null && !trader.hasPermission(this.menu.getBE().getReferencedPlayer(), "interactionLink")) {
            list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.info.trader.permissions", new Object[0]).m_130940_(ChatFormatting.RED));
        }
        return list;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        BankAccount account;
        if (this.menu.getBE() == null) {
            return;
        }
        gui.drawString((Component)this.menu.getBE().m_58900_().m_60734_().m_49954_(), 8, 6, 0x404040);
        TraderData trader = this.menu.getBE().getTrader();
        MutableComponent infoText = trader != null ? trader.getTitle() : (this.menu.getBE().hasTrader() ? EasyText.translatable("gui.lightmanscurrency.interface.info.trader.removed", new Object[0]).m_130940_(ChatFormatting.RED) : EasyText.translatable("gui.lightmanscurrency.interface.info.trader.null", new Object[0]));
        gui.drawString(TextRenderUtil.fitString((Component)infoText, this.screen.getXSize() - 16), 8, 16, 0x404040);
        this.tradeDisplay.f_93624_ = this.menu.getBE().getInteractionType().trades;
        this.acceptChangesButton.f_93624_ = this.newTradeDisplay.f_93624_ = this.tradeDisplay.f_93624_ && this.changeInTrades();
        if (this.tradeDisplay.f_93624_ && this.menu.getBE().getReferencedTrade() == null) {
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.interface.info.trade.notdefined", new Object[0]), 6, 40, 0x404040);
        }
        if (this.newTradeDisplay.f_93624_) {
            gui.resetColor();
            gui.blit(TraderInterfaceScreen.GUI_TEXTURE, this.tradeDisplay.m_5711_() / 2 - 2, 67, 206, 18, 16, 22);
            if (this.menu.getBE().getTrueTrade() == null) {
                MutableComponent mutableComponent = EasyText.translatable("gui.lightmanscurrency.interface.info.trade.missing", new Object[0]).m_130940_(ChatFormatting.RED);
                Objects.requireNonNull(gui.font);
                gui.drawString((Component)mutableComponent, 6, 109 - 9, 0x404040);
            }
        }
        if ((account = this.menu.getBE().getBankAccount()) != null && this.menu.getBE().getInteractionType().trades) {
            Component accountName = TextRenderUtil.fitString((Component)account.getName(), 160);
            gui.drawString(accountName, 103 - gui.font.m_92852_((FormattedText)accountName) / 2, 120, 0x404040);
            MutableComponent balanceText = EasyText.translatable("gui.lightmanscurrency.bank.balance", account.getCoinStorage().getComponent("0"));
            gui.drawString((Component)balanceText, 103 - gui.font.m_92852_((FormattedText)balanceText) / 2, 130, 0x404040);
        }
        if (this.getWarningMessages().size() > 0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TraderInterfaceScreen.GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.resetColor();
            gui.blit(TraderInterfaceScreen.GUI_TEXTURE, this.WARNING_AREA.x, this.WARNING_AREA.y, 206, 40, 16, 16);
        }
    }

    public boolean changeInTrades() {
        TradeData referencedTrade = this.menu.getBE().getReferencedTrade();
        TradeData trueTrade = this.menu.getBE().getTrueTrade();
        if (referencedTrade == null) {
            return false;
        }
        if (trueTrade == null) {
            return true;
        }
        return !referencedTrade.compare(trueTrade).Identical();
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        List<Component> warnings;
        if (this.menu.getBE() == null) {
            return;
        }
        if (this.WARNING_AREA.atPosition(this.WARNING_AREA.pos.offset(this.screen)).isMouseInArea(gui.mousePos) && (warnings = this.getWarningMessages()).size() > 0) {
            gui.renderComponentTooltip(warnings);
        }
    }

    private void onInteractionSelect(int newTypeIndex) {
        TraderInterfaceBlockEntity.InteractionType newType = TraderInterfaceBlockEntity.InteractionType.fromIndex(newTypeIndex);
        ((InfoTab)this.commonTab).changeInteractionType(newType);
    }

    private void AcceptTradeChanges(EasyButton button) {
        ((InfoTab)this.commonTab).acceptTradeChanges();
    }
}

