/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionCreateTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.message.persistentdata.CPacketCreatePersistentAuction;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;

public class AuctionCreateClientTab
extends TraderStorageClientTab<AuctionCreateTab> {
    public static final long CLOSE_DELAY = 5000L;
    AuctionTradeData pendingAuction;
    TradeButton tradeDisplay;
    CoinValueInput priceSelect;
    EasyButton buttonTogglePriceMode;
    boolean startingBidMode = true;
    EasyButton buttonSubmitAuction;
    boolean locked = false;
    long successTime = 0L;
    EasyButton buttonSubmitPersistentAuction;
    EditBox persistentAuctionIDInput;
    TimeInputWidget timeInput;

    public AuctionCreateClientTab(Object screen, AuctionCreateTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_PLUS;
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.auction.create", new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return LCAdminMode.isAdminPlayer(((TraderStorageMenu)this.screen.m_6262_()).player);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        if (firstOpen) {
            this.pendingAuction = new AuctionTradeData(this.menu.player);
            this.locked = false;
            this.successTime = 0L;
            this.startingBidMode = true;
            ((AuctionCreateTab)this.commonTab).getAuctionItems().m_19164_(c -> this.UpdateAuctionItems());
        }
        this.tradeDisplay = this.addChild(new TradeButton(this.menu::getContext, () -> this.pendingAuction, b -> {}));
        this.tradeDisplay.setPosition(screenArea.pos.offset(15, 5));
        this.priceSelect = this.addChild(new CoinValueInput(screenArea.pos.offset(screenArea.width / 2 - 88, 34), (Component)EasyText.empty(), CoinValue.EMPTY, this.getFont(), this::onPriceChanged));
        this.priceSelect.allowFreeToggle = false;
        this.priceSelect.drawBG = false;
        this.buttonTogglePriceMode = this.addChild(new EasyTextButton(screenArea.pos.offset(114, 5), screenArea.width - 119, 20, (Component)EasyText.translatable("button.lightmanscurrency.auction.toggleprice.startingbid", new Object[0]), b -> this.TogglePriceTarget()));
        this.timeInput = this.addChild(new TimeInputWidget(screenArea.pos.offset(80, 112), 10, TimeUtil.TimeUnit.DAY, TimeUtil.TimeUnit.HOUR, this::updateDuration));
        this.timeInput.minDuration = Math.max((long)((Integer)Config.SERVER.minAuctionDuration.get()).intValue() * 86400000L, 3600000L);
        this.timeInput.maxDuration = (long)Math.max((Integer)Config.SERVER.maxAuctionDuration.get(), (Integer)Config.SERVER.minAuctionDuration.get()) * 86400000L;
        this.timeInput.setTime(this.timeInput.minDuration);
        this.buttonSubmitAuction = this.addChild(new EasyTextButton(screenArea.pos.offset(40, -20), screenArea.width - 80, 20, (Component)EasyText.translatable("button.lightmanscurrency.auction.create", new Object[0]), b -> this.submitAuction()));
        this.buttonSubmitAuction.f_93623_ = false;
        this.buttonSubmitPersistentAuction = this.addChild(new IconButton(screenArea.pos.offset(screenArea.width - 20, -20), this::submitPersistentAuction, IconAndButtonUtil.ICON_PERSISTENT_DATA).withAddons(EasyAddonHelper.tooltip(IconAndButtonUtil.TOOLTIP_PERSISTENT_AUCTION)));
        this.buttonSubmitPersistentAuction.f_93624_ = LCAdminMode.isAdminPlayer(((TraderStorageMenu)this.screen.m_6262_()).player);
        this.buttonSubmitPersistentAuction.f_93623_ = false;
        int idWidth = this.getFont().m_92852_((FormattedText)EasyText.translatable("gui.lightmanscurrency.settings.persistent.id", new Object[0]));
        this.persistentAuctionIDInput = this.addChild(new EditBox(this.getFont(), screenArea.x + idWidth + 2, screenArea.y - 40, screenArea.width - idWidth - 2, 18, (Component)EasyText.empty()));
        this.persistentAuctionIDInput.f_93624_ = LCAdminMode.isAdminPlayer(((TraderStorageMenu)this.screen.m_6262_()).player);
    }

    @Override
    public void closeAction() {
        ((AuctionCreateTab)this.commonTab).getAuctionItems().m_19181_(c -> this.UpdateAuctionItems());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.resetColor();
        for (SimpleSlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
            gui.blit(TraderScreen.GUI_TEXTURE, slot.f_40220_ - 1, slot.f_40221_ - 1, 206, 0, 18, 18);
        }
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.auction.auctionitems", new Object[0]), 22, 112, 0x404040);
        if (this.locked && this.successTime != 0L) {
            TextRenderUtil.drawCenteredText(gui, (Component)EasyText.translatable("gui.lightmanscurrency.auction.create.success", new Object[0]).m_130940_(ChatFormatting.BOLD), this.screen.getXSize() / 2, 34, 0x404040);
        }
        if (LCAdminMode.isAdminPlayer(((TraderStorageMenu)this.screen.m_6262_()).player)) {
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.persistent.id", new Object[0]), 0, -35, 0xFFFFFF);
        }
    }

    @Override
    public void tick() {
        this.priceSelect.locked = this.locked;
        this.priceSelect.tick();
        if (this.locked && this.successTime != 0L && TimeUtil.compareTime(5000L, this.successTime)) {
            this.screen.changeTab(0);
            return;
        }
        if (this.locked) {
            this.buttonSubmitAuction.f_93623_ = false;
            this.buttonTogglePriceMode.f_93623_ = false;
        } else {
            this.buttonTogglePriceMode.f_93623_ = true;
            this.buttonSubmitAuction.f_93623_ = this.pendingAuction.isValid();
        }
        if (LCAdminMode.isAdminPlayer(((TraderStorageMenu)this.screen.m_6262_()).player)) {
            this.persistentAuctionIDInput.f_93624_ = !this.locked;
            this.buttonSubmitPersistentAuction.f_93624_ = this.persistentAuctionIDInput.f_93624_;
            this.buttonSubmitPersistentAuction.f_93623_ = this.pendingAuction.isValid();
            this.persistentAuctionIDInput.m_94120_();
        } else {
            this.persistentAuctionIDInput.f_93624_ = false;
            this.buttonSubmitPersistentAuction.f_93624_ = false;
        }
    }

    private void UpdateAuctionItems() {
        this.pendingAuction.setAuctionItems((Container)((AuctionCreateTab)this.commonTab).getAuctionItems());
    }

    private void onPriceChanged(CoinValue newPrice) {
        if (this.startingBidMode) {
            this.pendingAuction.setStartingBid(newPrice);
        } else {
            this.pendingAuction.setMinBidDifferent(newPrice);
        }
    }

    private void TogglePriceTarget() {
        this.startingBidMode = !this.startingBidMode;
        this.buttonTogglePriceMode.m_93666_((Component)EasyText.translatable(this.startingBidMode ? "button.lightmanscurrency.auction.toggleprice.startingbid" : "button.lightmanscurrency.auction.toggleprice.mindeltabid", new Object[0]));
        if (this.startingBidMode) {
            this.priceSelect.setCoinValue(this.pendingAuction.getLastBidAmount());
        } else {
            this.priceSelect.setCoinValue(this.pendingAuction.getMinBidDifference());
        }
    }

    private void updateDuration(TimeUtil.TimeData newTime) {
        this.pendingAuction.setDuration(newTime.miliseconds);
    }

    private void submitAuction() {
        ((AuctionCreateTab)this.commonTab).createAuction(this.pendingAuction);
        this.locked = true;
        for (SimpleSlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
            slot.locked = true;
        }
    }

    private void submitPersistentAuction(EasyButton button) {
        new CPacketCreatePersistentAuction(this.pendingAuction.getAsNBT(), this.persistentAuctionIDInput.m_94155_()).send();
    }

    @Override
    public void receiveServerMessage(LazyPacketData message) {
        if (message.contains("AuctionCreated")) {
            if (message.getBoolean("AuctionCreated")) {
                this.successTime = TimeUtil.getCurrentTime();
            } else {
                this.locked = false;
                for (SimpleSlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
                    slot.locked = false;
                }
            }
        }
    }
}

