/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class AuctionStorageClientTab
extends TraderStorageClientTab<AuctionStorageTab>
implements IScrollable,
IMouseListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int COLUMNS = 10;
    private static final int ROWS = 4;
    int scroll = 0;
    ScrollBarWidget scrollBar;
    EasyButton buttonCollectItems;
    IconButton buttonCollectMoney;

    public AuctionStorageClientTab(Object screen, AuctionStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORAGE;
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.auction.storage", new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.scrollBar = this.addChild(new ScrollBarWidget(screenArea.pos.offset(193, 17), 72, this));
        this.buttonCollectItems = this.addChild(IconAndButtonUtil.quickExtractButton(screenArea.pos.offset(11, 97), b -> ((AuctionStorageTab)this.commonTab).quickTransfer()));
        this.buttonCollectMoney = this.addChild(new IconButton(screenArea.pos.offset(25, 118), b -> ((AuctionStorageTab)this.commonTab).collectCoins(), IconAndButtonUtil.ICON_COLLECT_COINS));
        this.addChild(new ScrollListener(screenArea.pos, screenArea.width, 118, this));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)EasyText.translatable("tooltip.lightmanscurrency.auction.storage", new Object[0]), 8, 6, 0x404040);
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)traderData;
            this.validateScroll();
            int index = this.scroll * 10;
            AuctionPlayerStorage storage = trader.getStorage(this.menu.player);
            if (storage != null) {
                List<ItemStack> storedItems = storage.getStoredItems();
                int hoverSlot = this.isMouseOverSlot(gui.mousePos) + this.scroll * 10;
                for (int y = 0; y < 4 && index < storedItems.size(); ++y) {
                    int yPos = 17 + y * 18;
                    for (int x = 0; x < 10 && index < storedItems.size(); ++index, ++x) {
                        int xPos = 13 + x * 18;
                        gui.resetColor();
                        gui.blit(TraderScreen.GUI_TEXTURE, xPos, yPos, 206, 0, 18, 18);
                        if (index < storedItems.size()) {
                            gui.renderItem(storedItems.get(index), xPos + 1, yPos + 1);
                        }
                        if (index != hoverSlot) continue;
                        gui.renderSlotHighlight(xPos + 1, yPos + 1);
                    }
                }
                if (storedItems.size() == 0) {
                    TextRenderUtil.drawCenteredMultilineText(gui, (Component)EasyText.translatable("tooltip.lightmanscurrency.auction.storage.items.none", new Object[0]), 10, this.screen.getXSize() - 20, 49, 0x404040);
                }
                boolean bl = this.buttonCollectItems.f_93623_ = storedItems.size() > 0;
                if (storage.getStoredCoins().hasAny()) {
                    this.buttonCollectMoney.f_93623_ = true;
                    gui.drawString((Component)EasyText.translatable("tooltip.lightmanscurrency.auction.storage.money", storage.getStoredCoins().getString("0")), 50, 118, 0x404040);
                } else {
                    this.buttonCollectMoney.f_93623_ = false;
                    gui.drawString((Component)EasyText.translatable("tooltip.lightmanscurrency.auction.storage.money.none", new Object[0]), 50, 118, 0x404040);
                }
            }
        }
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        AuctionPlayerStorage storage;
        int hoveredSlot;
        if (this.menu.getTrader() instanceof AuctionHouseTrader && ((TraderStorageMenu)this.screen.m_6262_()).m_142621_().m_41619_() && (hoveredSlot = this.isMouseOverSlot(gui.mousePos)) >= 0 && (hoveredSlot += this.scroll * 10) < (storage = ((AuctionHouseTrader)this.menu.getTrader()).getStorage(this.menu.player)).getStoredItems().size()) {
            ItemStack stack = storage.getStoredItems().get(hoveredSlot);
            gui.renderComponentTooltip(EasyScreenHelper.getTooltipFromItem(stack));
        }
    }

    private int isMouseOverSlot(ScreenPosition mousePos) {
        int foundColumn = -1;
        int foundRow = -1;
        int leftEdge = this.screen.getGuiLeft() + 13;
        int topEdge = this.screen.getGuiTop() + 17;
        for (int x = 0; x < 10 && foundColumn < 0; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            foundColumn = x;
        }
        for (int y = 0; y < 4 && foundRow < 0; ++y) {
            if (mousePos.y < topEdge + y * 18 || mousePos.y >= topEdge + y * 18 + 18) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * 10 + foundColumn;
    }

    private int totalStorageSlots() {
        if (this.menu.getTrader() instanceof AuctionHouseTrader) {
            return ((AuctionHouseTrader)this.menu.getTrader()).getStorage(this.menu.player).getStoredItems().size();
        }
        return 0;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (this.menu.getTrader() instanceof AuctionHouseTrader && (hoveredSlot = this.isMouseOverSlot(ScreenPosition.of(mouseX, mouseY))) >= 0) {
            ((AuctionStorageTab)this.commonTab).clickedOnSlot(hoveredSlot += this.scroll * 10, Screen.m_96638_());
            return true;
        }
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.totalStorageSlots() - 1) / 10 - 4 + 1, 0);
    }
}

