/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class OwnershipTab
extends SettingsSubTab {
    EditBox newOwnerInput;
    EasyButton buttonSetOwner;
    TeamSelectWidget teamSelection;
    EasyButton buttonSetTeamOwner;
    long selectedTeam = -1L;
    List<Team> teamList = Lists.newArrayList();

    public OwnershipTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_ALEX_HEAD;
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.settings.owner", new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("transferOwnership");
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.newOwnerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 20, screenArea.y + 20, 160, 20, (Component)EasyText.empty()));
        this.newOwnerInput.m_94199_(16);
        this.buttonSetOwner = this.addChild(new EasyTextButton(screenArea.pos.offset(20, 41), 160, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.set_owner", new Object[0]), this::setOwner).withAddons(EasyAddonHelper.tooltip(IconAndButtonUtil.TOOLTIP_CANNOT_BE_UNDONE)));
        this.buttonSetOwner.f_93623_ = false;
        this.teamSelection = this.addChild(new TeamSelectWidget(screenArea.pos.offset(10, 65), 3, () -> this.teamList, this::getSelectedTeam, this::selectTeam));
        this.buttonSetTeamOwner = this.addChild(new EasyTextButton(screenArea.pos.offset(20, 130), 160, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.set_owner", new Object[0]), this::setTeamOwner).withAddons(EasyAddonHelper.tooltip(IconAndButtonUtil.TOOLTIP_CANNOT_BE_UNDONE)));
        this.buttonSetTeamOwner.f_93623_ = false;
    }

    @Override
    protected void onSubtabClose() {
        this.selectedTeam = -1L;
        this.teamList = Lists.newArrayList();
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private Team getSelectedTeam() {
        if (this.selectedTeam < 0L) {
            return null;
        }
        return TeamSaveData.GetTeam(true, this.selectedTeam);
    }

    private void refreshTeamList() {
        this.teamList = Lists.newArrayList();
        List<Team> allTeams = TeamSaveData.GetAllTeams(true);
        allTeams.forEach(team -> {
            if (team.isMember(this.menu.player)) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.menu.player));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            gui.drawString((Component)EasyText.translatable("gui.button.lightmanscurrency.team.owner", trader.getOwner().getOwnerName(true)), 20, 10, 0x404040);
        }
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.newOwnerInput.m_94120_();
        this.buttonSetOwner.f_93623_ = !this.newOwnerInput.m_94155_().isBlank();
        this.buttonSetTeamOwner.f_93623_ = this.getSelectedTeam() != null;
    }

    private void selectTeam(int teamIndex) {
        Team newTeam = this.getTeam(teamIndex);
        if (newTeam != null) {
            this.selectedTeam = newTeam.getID() == this.selectedTeam ? -1L : newTeam.getID();
        }
    }

    private void setOwner(EasyButton button) {
        if (this.newOwnerInput.m_94155_().isBlank()) {
            return;
        }
        this.sendMessage(LazyPacketData.simpleString("ChangePlayerOwner", this.newOwnerInput.m_94155_()));
        this.newOwnerInput.m_94144_("");
    }

    private void setTeamOwner(EasyButton button) {
        if (this.getSelectedTeam() == null) {
            return;
        }
        this.sendMessage(LazyPacketData.simpleLong("ChangeTeamOwner", this.selectedTeam));
        this.selectedTeam = -1L;
    }

    @Override
    public boolean shouldRenderInventoryText() {
        return false;
    }
}

