/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class TradeRuleSubTab<T extends TradeRule>
extends TradeRulesClientSubTab {
    public final ResourceLocation ruleType;

    public TradeRuleSubTab(@Nonnull TradeRulesClientTab<?> parent, @Nonnull ResourceLocation ruleType) {
        super(parent);
        this.ruleType = ruleType;
    }

    @Nullable
    protected final T getRule() {
        ITradeRuleHost host = this.commonTab.getHost();
        if (host != null) {
            try {
                return (T)host.getRuleOfType(this.ruleType);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean isVisible() {
        T rule = this.getRule();
        if (rule != null) {
            return ((TradeRule)rule).isActive();
        }
        return false;
    }

    public MutableComponent getTooltip() {
        return TradeRule.nameOfType(this.ruleType);
    }

    public void sendUpdateMessage(@Nonnull CompoundTag updateInfo) {
        this.commonTab.EditTradeRule(this.ruleType, updateInfo);
    }
}

