/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.RuleToggleTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trade_rules.TradeRulesTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;

public abstract class TradeRulesClientTab<T extends TradeRulesTab>
extends TraderStorageClientTab<T> {
    private int selectedTab = 0;
    private final List<TabButton> tabButtons = new ArrayList<TabButton>();
    private final List<TradeRulesClientSubTab> tabs = new ArrayList<TradeRulesClientSubTab>();

    private TradeRulesClientSubTab getCurrentTab() {
        if (this.selectedTab < 0 || this.selectedTab >= this.tabs.size()) {
            this.selectedTab = 0;
        }
        if (this.tabs.size() > 0) {
            return this.tabs.get(this.selectedTab);
        }
        return null;
    }

    protected TradeRulesClientTab(Object screen, T commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TRADE_RULES;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.tabButtons.clear();
        this.refreshTabs();
        this.getCurrentTab().onOpen();
        this.tick();
        this.menu.SetCoinSlotsActive(false);
    }

    @Override
    public void closeAction() {
        this.menu.SetCoinSlotsActive(true);
    }

    public void refreshTabs() {
        this.tabs.clear();
        this.tabs.add(new RuleToggleTab(this));
        this.selectedTab = 0;
        ITradeRuleHost host = ((TradeRulesTab)this.commonTab).getHost();
        if (host != null) {
            for (TradeRule rule : host.getRules()) {
                try {
                    this.tabs.add(rule.createTab(this));
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Trade Rule of type '" + rule.type + "' encountered an error creating its tab. Trade Rule will not be editable!", t);
                }
            }
        }
        for (TabButton b2 : this.tabButtons) {
            this.removeChild(b2);
        }
        this.tabButtons.clear();
        int i = 0;
        while (i < this.tabs.size()) {
            int tabIndex = i++;
            this.tabButtons.add(this.addChild(new TabButton(b -> this.openTab(tabIndex), this.tabs.get(tabIndex))));
        }
    }

    public void openTab(int index) {
        if (index == this.selectedTab || index < 0 || index >= this.tabs.size()) {
            return;
        }
        this.getCurrentTab().onClose();
        this.selectedTab = index;
        this.getCurrentTab().onOpen();
    }

    @Override
    public void tick() {
        for (int i = 0; i < this.tabs.size() && i < this.tabButtons.size(); ++i) {
            this.tabButtons.get((int)i).f_93624_ = this.tabs.get(i).isVisible();
            this.tabButtons.get((int)i).f_93623_ = this.selectedTab != i;
        }
        ScreenArea screenArea = this.screen.getArea();
        int yPos = 0;
        for (TabButton button : this.tabButtons) {
            if (!button.f_93624_) continue;
            button.reposition(screenArea.pos.offset(screenArea.width, yPos), 1);
            yPos += 25;
        }
        this.getCurrentTab().tick();
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.getCurrentTab().renderBG(gui);
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        this.getCurrentTab().renderAfterWidgets(gui);
    }

    public static class Trade
    extends TradeRulesClientTab<TradeRulesTab.Trade> {
        public Trade(Object screen, TradeRulesTab.Trade commonTab) {
            super(screen, commonTab);
        }

        @Override
        public boolean tabButtonVisible() {
            return false;
        }

        public MutableComponent getTooltip() {
            return IconAndButtonUtil.TOOLTIP_TRADE_RULES_TRADE;
        }

        @Override
        public void receiveSelfMessage(LazyPacketData message) {
            ((TradeRulesTab.Trade)this.commonTab).receiveMessage(message);
        }
    }

    public static class Trader
    extends TradeRulesClientTab<TradeRulesTab.Trader> {
        public Trader(Object screen, TradeRulesTab.Trader commonTab) {
            super(screen, commonTab);
        }

        public MutableComponent getTooltip() {
            return IconAndButtonUtil.TOOLTIP_TRADE_RULES_TRADER;
        }
    }
}

