/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRuleSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class PlayerTradeLimitTab
extends TradeRuleSubTab<PlayerTradeLimit> {
    EditBox limitInput;
    EasyButton buttonSetLimit;
    EasyButton buttonClearMemory;
    TimeInputWidget timeInput;

    public PlayerTradeLimitTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent, PlayerTradeLimit.TYPE);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_COUNT_PLAYER;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.limitInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 19, 30, 20, (Component)EasyText.empty()));
        this.limitInput.m_94199_(3);
        PlayerTradeLimit rule = (PlayerTradeLimit)this.getRule();
        if (rule != null) {
            this.limitInput.m_94144_(Integer.toString(rule.getLimit()));
        }
        this.buttonSetLimit = this.addChild(new EasyTextButton(screenArea.pos.offset(41, 19), 40, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.playerlimit.setlimit", new Object[0]), this::PressSetLimitButton));
        this.buttonClearMemory = this.addChild(new EasyTextButton(screenArea.pos.offset(10, 50), screenArea.width - 20, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.playerlimit.clearmemory", new Object[0]), this::PressClearMemoryButton).withAddons(EasyAddonHelper.tooltip((Component)EasyText.translatable("gui.button.lightmanscurrency.playerlimit.clearmemory.tooltip", new Object[0]))));
        this.timeInput = this.addChild(new TimeInputWidget(screenArea.pos.offset(63, 87), 10, TimeUtil.TimeUnit.DAY, TimeUtil.TimeUnit.MINUTE, this::onTimeSet));
        this.timeInput.setTime(((PlayerTradeLimit)this.getRule()).getTimeLimit());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        PlayerTradeLimit rule = (PlayerTradeLimit)this.getRule();
        if (rule != null) {
            gui.drawString(EasyText.translatable("gui.button.lightmanscurrency.playerlimit.info", rule.getLimit()).getString(), 10, 9, 0xFFFFFF);
        }
        MutableComponent text = ((PlayerTradeLimit)this.getRule()).getTimeLimit() > 0L ? EasyText.translatable("gui.widget.lightmanscurrency.playerlimit.duration", new TimeUtil.TimeData(((PlayerTradeLimit)this.getRule()).getTimeLimit()).getShortString()) : EasyText.translatable("gui.widget.lightmanscurrency.playerlimit.noduration", new Object[0]);
        TextRenderUtil.drawCenteredText(gui, (Component)text, this.screen.getXSize() / 2, 75, 0xFFFFFF);
    }

    @Override
    public void tick() {
        TextInputUtil.whitelistInteger(this.limitInput, 1L, 100L);
    }

    void PressSetLimitButton(EasyButton button) {
        int limit = MathUtil.clamp(TextInputUtil.getIntegerValue(this.limitInput), 1, 100);
        PlayerTradeLimit rule = (PlayerTradeLimit)this.getRule();
        if (rule != null) {
            rule.setLimit(limit);
        }
        CompoundTag updateInfo = new CompoundTag();
        updateInfo.m_128405_("Limit", limit);
        this.sendUpdateMessage(updateInfo);
    }

    void PressClearMemoryButton(EasyButton button) {
        PlayerTradeLimit rule = (PlayerTradeLimit)this.getRule();
        if (rule != null) {
            rule.resetMemory();
        }
        CompoundTag updateInfo = new CompoundTag();
        updateInfo.m_128379_("ClearMemory", true);
        this.sendUpdateMessage(updateInfo);
    }

    public void onTimeSet(TimeUtil.TimeData newTime) {
        long timeLimit = MathUtil.clamp(newTime.miliseconds, 0L, Long.MAX_VALUE);
        PlayerTradeLimit rule = (PlayerTradeLimit)this.getRule();
        if (rule != null) {
            rule.setTimeLimit(timeLimit);
        }
        CompoundTag updateInfo = new CompoundTag();
        updateInfo.m_128356_("TimeLimit", timeLimit);
        this.sendUpdateMessage(updateInfo);
    }
}

