/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRuleSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TimedSale;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public class TimedSaleTab
extends TradeRuleSubTab<TimedSale> {
    EditBox discountInput;
    EasyButton buttonSetDiscount;
    EasyButton buttonStartSale;
    TimeInputWidget durationInput;

    public TimedSaleTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent, TimedSale.TYPE);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TIMED_SALE;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.discountInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 25, screenArea.y + 9, 20, 20, (Component)EasyText.empty()));
        this.discountInput.m_94199_(2);
        TimedSale rule = (TimedSale)this.getRule();
        if (rule != null) {
            this.discountInput.m_94144_(Integer.toString(rule.getDiscount()));
        }
        this.buttonSetDiscount = this.addChild(new EasyTextButton(screenArea.pos.offset(125, 10), 50, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.discount.set", new Object[0]), this::PressSetDiscountButton));
        this.buttonStartSale = this.addChild(new EasyTextButton(screenArea.pos.offset(25, 45), 156, 20, (NonNullSupplier<Component>)((NonNullSupplier)this::getButtonText), this::PressStartButton).withAddons(EasyAddonHelper.tooltip(this::getButtonTooltip)));
        this.durationInput = this.addChild(new TimeInputWidget(screenArea.pos.offset(63, 75), 10, TimeUtil.TimeUnit.DAY, TimeUtil.TimeUnit.MINUTE, this::onTimeSet));
        this.durationInput.setTime(((TimedSale)this.getRule()).getDuration());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        if (this.getRule() == null) {
            return;
        }
        gui.pushOffset((AbstractWidget)this.discountInput);
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.discount.tooltip", new Object[0]), this.discountInput.m_5711_() + 4, 3, 0xFFFFFF);
        gui.popOffset();
        MutableComponent infoText = EasyText.translatable("gui.button.lightmanscurrency.timed_sale.info.inactive", new TimeUtil.TimeData(((TimedSale)this.getRule()).getDuration()).getShortString());
        if (((TimedSale)this.getRule()).timerActive()) {
            infoText = EasyText.translatable("gui.button.lightmanscurrency.timed_sale.info.active", ((TimedSale)this.getRule()).getTimeRemaining().getShortString(3));
        }
        gui.drawString((Component)infoText, 25, 35, 0xFFFFFF);
    }

    @Override
    public void tick() {
        this.buttonStartSale.m_93666_(this.getButtonText());
        TimedSale rule = (TimedSale)this.getRule();
        this.buttonStartSale.f_93623_ = rule != null && (rule.timerActive() || rule.getDuration() > 0L && rule.isActive());
        TextInputUtil.whitelistInteger(this.discountInput, 0L, 99L);
    }

    private Component getButtonText() {
        TimedSale rule = (TimedSale)this.getRule();
        return EasyText.translatable("gui.button.lightmanscurrency.timed_sale." + (rule != null && rule.timerActive() ? "stop" : "start"), new Object[0]);
    }

    private Component getButtonTooltip() {
        TimedSale rule = (TimedSale)this.getRule();
        return EasyText.translatable("gui.button.lightmanscurrency.timed_sale." + (rule != null && rule.timerActive() ? "stop" : "start") + ".tooltip", new Object[0]);
    }

    void PressSetDiscountButton(EasyButton button) {
        int discount = TextInputUtil.getIntegerValue(this.discountInput, 1);
        TimedSale rule = (TimedSale)this.getRule();
        if (rule != null) {
            rule.setDiscount(discount);
        }
        CompoundTag updateInfo = new CompoundTag();
        updateInfo.m_128405_("Discount", discount);
        this.sendUpdateMessage(updateInfo);
    }

    void PressStartButton(EasyButton button) {
        boolean setActive;
        TimedSale rule = (TimedSale)this.getRule();
        boolean bl = setActive = rule != null && !rule.timerActive();
        if (rule != null) {
            rule.setStartTime(rule.timerActive() ? 0L : TimeUtil.getCurrentTime());
        }
        CompoundTag updateInfo = new CompoundTag();
        updateInfo.m_128379_("StartSale", setActive);
        this.sendUpdateMessage(updateInfo);
    }

    public void onTimeSet(TimeUtil.TimeData newTime) {
        TimedSale rule = (TimedSale)this.getRule();
        if (rule != null) {
            rule.setDuration(newTime.miliseconds);
        }
        CompoundTag updateInfo = new CompoundTag();
        updateInfo.m_128356_("Duration", newTime.miliseconds);
        this.sendUpdateMessage(updateInfo);
    }
}

