/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class TeamMemberEditTab
extends TeamTab {
    ScrollTextDisplay memberDisplay;
    EditBox memberNameInput;
    EasyButton buttonAddMember;
    EasyButton buttonPromoteMember;
    EasyButton buttonRemoveMember;

    public TeamMemberEditTab(TeamManagerScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_ALEX_HEAD;
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.team.member_edit", new Object[0]);
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return team != null;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.memberNameInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 11, screenArea.y + 9, 178, 20, (Component)EasyText.empty()));
        this.memberNameInput.m_94199_(16);
        this.buttonAddMember = this.addChild(new EasyTextButton(screenArea.pos.offset(10, 30), 60, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.team.member.add", new Object[0]), this::addMember));
        this.buttonPromoteMember = this.addChild(new EasyTextButton(screenArea.pos.offset(70, 30), 60, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.team.member.promote", new Object[0]), this::addAdmin));
        this.buttonRemoveMember = this.addChild(new EasyTextButton(screenArea.pos.offset(130, 30), 60, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.team.member.remove", new Object[0]), this::removeMember));
        this.buttonRemoveMember.f_93623_ = false;
        this.buttonPromoteMember.f_93623_ = false;
        this.buttonAddMember.f_93623_ = false;
        this.memberDisplay = this.addChild(new ScrollTextDisplay(screenArea.pos.offset(10, 55), screenArea.width - 20, screenArea.height - 65, (Supplier<List<? extends Component>>)((Supplier)this::getMemberList)));
        this.memberDisplay.setColumnCount(2);
    }

    private List<Component> getMemberList() {
        ArrayList list = Lists.newArrayList();
        Team team = this.getActiveTeam();
        if (team != null) {
            team.getAdmins().forEach(admin -> list.add(admin.getNameComponent(true).m_130940_(ChatFormatting.DARK_GREEN)));
            team.getMembers().forEach(member -> list.add(member.getNameComponent(true)));
        }
        return list;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }

    @Override
    public void tick() {
        if (this.getActiveTeam().isAdmin(this.getPlayer())) {
            this.buttonRemoveMember.f_93623_ = !this.memberNameInput.m_94155_().isBlank();
            this.buttonPromoteMember.f_93623_ = this.buttonRemoveMember.f_93623_;
            this.buttonAddMember.f_93623_ = this.buttonRemoveMember.f_93623_;
        } else {
            this.buttonPromoteMember.f_93623_ = false;
            this.buttonAddMember.f_93623_ = false;
            this.buttonRemoveMember.f_93623_ = this.getPlayer().m_36316_().getName().equalsIgnoreCase(this.memberNameInput.m_94155_());
        }
    }

    private void addMember(EasyButton button) {
        if (this.memberNameInput.m_94155_().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeAddMember(this.getPlayer(), this.memberNameInput.m_94155_());
        this.RequestChange(LazyPacketData.simpleString("AddMember", this.memberNameInput.m_94155_()));
        this.memberNameInput.m_94144_("");
    }

    private void addAdmin(EasyButton button) {
        if (this.memberNameInput.m_94155_().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeAddAdmin(this.getPlayer(), this.memberNameInput.m_94155_());
        this.RequestChange(LazyPacketData.simpleString("AddAdmin", this.memberNameInput.m_94155_()));
        this.memberNameInput.m_94144_("");
    }

    private void removeMember(EasyButton button) {
        if (this.memberNameInput.m_94155_().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeRemoveMember(this.getPlayer(), this.memberNameInput.m_94155_());
        this.RequestChange(LazyPacketData.simpleString("RemoveMember", this.memberNameInput.m_94155_()));
        this.memberNameInput.m_94144_("");
    }
}

