/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class TeamNameTab
extends TeamTab {
    EditBox nameInput;
    EasyButton buttonChangeName;

    public TeamNameTab(TeamManagerScreen screen) {
        super(screen);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((Component)EasyText.translatable("gui.button.lightmanscurrency.changename", new Object[0]));
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.team.name", new Object[0]);
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return team != null && team.isAdmin(player);
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.nameInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 20, screenArea.y + 20, 160, 20, (Component)EasyText.empty()));
        this.nameInput.m_94199_(32);
        this.nameInput.m_94144_(this.getActiveTeam().getName());
        this.buttonChangeName = this.addChild(new EasyTextButton(screenArea.pos.offset(20, 45), 160, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.team.rename", new Object[0]), this::changeName));
        this.buttonChangeName.f_93623_ = false;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        String currentName = "NULL";
        if (this.getActiveTeam() != null) {
            currentName = this.getActiveTeam().getName();
        }
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.team.name.current", currentName), 20, 10, 0x404040);
    }

    @Override
    public void tick() {
        this.nameInput.m_94120_();
        this.buttonChangeName.f_93623_ = !this.nameInput.m_94155_().isBlank() && !this.nameInput.m_94155_().contentEquals(this.getActiveTeam().getName());
    }

    private void changeName(EasyButton button) {
        if (this.nameInput.m_94155_().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        this.getActiveTeam().changeName(this.getPlayer(), this.nameInput.m_94155_());
        this.RequestChange(LazyPacketData.simpleString("ChangeName", this.nameInput.m_94155_()));
    }
}

