/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.easy.IEasyTickable;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankInteraction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;

public class BankAccountWidget
implements IEasyTickable {
    public static final int MIN_WIDTH = 100;
    public static final int HEIGHT = 109;
    public static final int BUTTON_WIDTH = 70;
    private final IBankAccountWidget parent;
    private final CoinValueInput amountSelection;
    private final EasyButton buttonDeposit;
    private final EasyButton buttonWithdraw;
    int y;
    int spacing;
    public boolean allowEmptyDeposits = true;

    public CoinValueInput getAmountSelection() {
        return this.amountSelection;
    }

    public BankAccountWidget(int y, IBankAccountWidget parent, Consumer<Object> addWidget) {
        this(y, parent, 0, addWidget);
    }

    public BankAccountWidget(int y, IBankAccountWidget parent, int spacing, Consumer<Object> addWidget) {
        this.parent = parent;
        this.y = y;
        this.spacing = spacing;
        int screenMiddle = this.parent.getScreen().f_96543_ / 2;
        this.amountSelection = new CoinValueInput(screenMiddle - 88, this.y, (Component)EasyText.translatable("gui.lightmanscurrency.bank.amounttip", new Object[0]), CoinValue.EMPTY, this.parent.getFont(), value -> {});
        this.amountSelection.allowFreeToggle = false;
        addWidget.accept(this.amountSelection);
        this.buttonDeposit = new EasyTextButton(screenMiddle - 5 - 70, this.y + 69 + 5 + spacing, 70, 20, (Component)EasyText.translatable("gui.button.bank.deposit", new Object[0]), this::OnDeposit);
        addWidget.accept((Object)this.buttonDeposit);
        this.buttonWithdraw = new EasyTextButton(screenMiddle + 5, this.y + 69 + 5 + spacing, 70, 20, (Component)EasyText.translatable("gui.button.bank.withdraw", new Object[0]), this::OnWithdraw);
        addWidget.accept((Object)this.buttonWithdraw);
        this.buttonWithdraw.f_93623_ = false;
        this.buttonDeposit.f_93623_ = false;
    }

    public void renderInfo(@Nonnull EasyGuiGraphics gui) {
        this.renderInfo(gui, 0);
    }

    public void renderInfo(@Nonnull EasyGuiGraphics gui, int yOffset) {
        int screenMiddle = this.parent.getScreen().f_96543_ / 2;
        MutableComponent balanceComponent = this.parent.getBankAccount() == null ? EasyText.translatable("gui.lightmanscurrency.bank.null", new Object[0]) : EasyText.translatable("gui.lightmanscurrency.bank.balance", this.parent.getBankAccount().getCoinStorage().getComponent("0"));
        int offset = gui.font.m_92895_(balanceComponent.getString()) / 2;
        gui.pushOffsetZero().drawString((Component)balanceComponent, screenMiddle - offset, this.y + 69 + 30 + this.spacing + yOffset, 0x404040);
        gui.popOffset();
    }

    @Override
    public void tick() {
        this.amountSelection.tick();
        if (this.parent.getBankAccount() == null) {
            this.buttonWithdraw.f_93623_ = false;
            this.buttonDeposit.f_93623_ = false;
        } else {
            this.buttonDeposit.f_93623_ = MoneyUtil.getValue(this.parent.getCoinAccess()) > 0L && (this.allowEmptyDeposits || this.amountSelection.getCoinValue().getValueNumber() > 0L);
            this.buttonWithdraw.f_93623_ = this.amountSelection.getCoinValue().getValueNumber() > 0L;
        }
    }

    private void OnDeposit(EasyButton button) {
        new CPacketBankInteraction(true, this.amountSelection.getCoinValue()).send();
        this.amountSelection.setCoinValue(CoinValue.EMPTY);
    }

    private void OnWithdraw(EasyButton button) {
        new CPacketBankInteraction(false, this.amountSelection.getCoinValue()).send();
        this.amountSelection.setCoinValue(CoinValue.EMPTY);
    }

    public static interface IBankAccountWidget {
        public Font getFont();

        public Screen getScreen();

        public BankAccount getBankAccount();

        public Container getCoinAccess();
    }
}

