/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class ItemEditWidget
extends EasyWidgetWithChildren
implements IScrollable,
ITooltipSource {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/item_edit.png");
    private static ItemEditWidget latestInstance = null;
    private static boolean rebuilding = false;
    private static final List<CreativeModeTab> ITEM_GROUP_BLACKLIST = new ArrayList<CreativeModeTab>();
    private static final List<Predicate<ItemStack>> ITEM_BLACKLIST = Lists.newArrayList((Object[])new Predicate[]{s -> s.m_41720_() instanceof TicketItem});
    private static final List<ItemInsertRule> ITEM_ADDITIONS = new ArrayList<ItemInsertRule>();
    private int scroll = 0;
    private int stackCount = 1;
    private final int columns;
    private final int rows;
    public int searchOffX;
    public int searchOffY;
    public int stackSizeOffX;
    public int stackSizeOffY;
    private static final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private static final Map<ResourceLocation, List<ItemStack>> preFilteredItems = new HashMap<ResourceLocation, List<ItemStack>>();
    private List<ItemStack> searchResultItems = new ArrayList<ItemStack>();
    private String searchString;
    EditBox searchInput;
    ScrollListener stackScrollListener;
    private final IItemEditListener listener;
    private final Font font;
    private final ItemEditWidget oldItemEdit;

    public static void BlacklistCreativeTabs(CreativeModeTab ... tabs) {
        for (CreativeModeTab tab : tabs) {
            ItemEditWidget.BlacklistCreativeTab(tab);
        }
    }

    public static void BlacklistCreativeTab(CreativeModeTab tab) {
        if (!ITEM_GROUP_BLACKLIST.contains(tab)) {
            ITEM_GROUP_BLACKLIST.add(tab);
        }
    }

    public static void BlacklistItem(RegistryObject<? extends ItemLike> item) {
        ItemEditWidget.BlacklistItem((ItemLike)item.get());
    }

    public static void BlacklistItem(ItemLike item) {
        ItemEditWidget.BlacklistItem((ItemStack s) -> s.m_41720_() == item.m_5456_());
    }

    public static void BlacklistItem(Predicate<ItemStack> itemFilter) {
        if (!ITEM_BLACKLIST.contains(itemFilter)) {
            ITEM_BLACKLIST.add(itemFilter);
        }
    }

    public static boolean IsCreativeTabAllowed(CreativeModeTab tab) {
        return !ITEM_GROUP_BLACKLIST.contains(tab);
    }

    public static void AddExtraItem(ItemStack item) {
        ITEM_ADDITIONS.add(ItemInsertRule.atEnd(item));
    }

    public static void AddExtraItemAfter(ItemStack item, @Nonnull Item afterItem) {
        ITEM_ADDITIONS.add(ItemInsertRule.afterItem(item, afterItem));
    }

    public static void AddExtraItemAfter(ItemStack item, @Nonnull Predicate<ItemStack> afterItem) {
        ITEM_ADDITIONS.add(ItemInsertRule.afterCheck(item, afterItem));
    }

    public static void AddExtraItemBefore(ItemStack item, @Nonnull Item beforeItem) {
        ITEM_ADDITIONS.add(ItemInsertRule.beforeItem(item, beforeItem));
    }

    public static void AddExtraItemBefore(ItemStack item, @Nonnull Predicate<ItemStack> beforeItem) {
        ITEM_ADDITIONS.add(ItemInsertRule.beforeCheck(item, beforeItem));
    }

    public static boolean isItemAllowed(ItemStack item) {
        for (Predicate<ItemStack> blacklist : ITEM_BLACKLIST) {
            if (!blacklist.test(item)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private EditBox getOldSearchInput() {
        return this.oldItemEdit != null ? this.oldItemEdit.searchInput : null;
    }

    private String getOldSearchString() {
        return this.oldItemEdit != null ? this.oldItemEdit.searchString : "";
    }

    public ItemEditWidget(ScreenPosition pos, int columns, int rows, @Nullable ItemEditWidget oldItemEdit, IItemEditListener listener) {
        this(pos.x, pos.y, columns, rows, oldItemEdit, listener);
    }

    public ItemEditWidget(int x, int y, int columns, int rows, @Nullable ItemEditWidget oldItemEdit, IItemEditListener listener) {
        super(x, y, columns * 18, rows * 18);
        latestInstance = this;
        this.listener = listener;
        this.oldItemEdit = oldItemEdit;
        this.columns = columns;
        this.rows = rows;
        this.searchOffX = this.f_93618_ - 90;
        this.searchOffY = -13;
        this.stackSizeOffX = this.f_93618_ + 13;
        this.stackSizeOffY = 0;
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
        ItemEditWidget.ConfirmItemListLoaded();
        this.modifySearch(this.getOldSearchString());
    }

    @Override
    public ItemEditWidget withAddons(WidgetAddon ... addons) {
        this.withAddonsInternal(addons);
        return this;
    }

    public static void ConfirmItemListLoaded() {
        if (allItems.size() == 0) {
            rebuilding = true;
        }
        new Thread(ItemEditWidget::safeInitItemList).start();
    }

    public static void safeInitItemList() {
        try {
            ItemEditWidget.initItemList();
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error occurred while attempting to set up the Item List!\nPlease report this error to the relevant mod author (if another mod is mentioned in the error), not to the Lightman's Currency Dev!", t);
        }
        rebuilding = false;
    }

    public static void initItemList() {
        if (allItems.size() > 0) {
            return;
        }
        rebuilding = true;
        LightmansCurrency.LogInfo("Pre-filtering item list for Item Edit items.");
        for (CreativeModeTab creativeTab : CreativeModeTab.f_40748_) {
            if (!ItemEditWidget.IsCreativeTabAllowed(creativeTab)) continue;
            NonNullList items = NonNullList.m_122779_();
            creativeTab.m_6151_(items);
            for (ItemStack stack : items) {
                if (!ItemEditWidget.isItemAllowed(stack)) continue;
                ItemEditWidget.addToList(stack);
                if (stack.m_41720_() != Items.f_42690_) continue;
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                enchantments.forEach((enchantment, level) -> {
                    for (int newLevel = level - 1; newLevel > 0; --newLevel) {
                        ItemStack newBook = new ItemStack((ItemLike)Items.f_42690_);
                        EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)enchantment, (Object)newLevel), (ItemStack)newBook);
                        if (!ItemEditWidget.isItemAllowed(newBook)) continue;
                        ItemEditWidget.addToList(newBook);
                    }
                });
            }
        }
        for (ItemInsertRule extraItemRule : ITEM_ADDITIONS) {
            ItemStack extraItem;
            if (!extraItemRule.shouldInsertAtEnd() || !ItemEditWidget.isItemAllowed(extraItem = extraItemRule.insertStack.m_41777_()) || !ItemEditWidget.notYetInList(extraItem)) continue;
            allItems.add(extraItem.m_41777_());
        }
        ItemTradeRestriction.forEach((type, restriction) -> preFilteredItems.put((ResourceLocation)type, allItems.stream().filter(restriction::allowItemSelectItem).collect(Collectors.toList())));
        if (latestInstance != null) {
            latestInstance.refreshSearch();
        }
    }

    private static void addToList(ItemStack stack) {
        if (ItemEditWidget.notYetInList(stack = stack.m_41777_())) {
            ItemStack extraItem;
            for (ItemInsertRule insertRule : ITEM_ADDITIONS) {
                if (!insertRule.shouldInsertBefore(stack) || !ItemEditWidget.isItemAllowed(extraItem = insertRule.insertStack.m_41777_()) || !ItemEditWidget.notYetInList(extraItem)) continue;
                allItems.add(extraItem);
            }
            allItems.add(stack);
            for (ItemInsertRule insertRule : ITEM_ADDITIONS) {
                if (!insertRule.shouldInsertAfter(stack) || !ItemEditWidget.isItemAllowed(extraItem = insertRule.insertStack.m_41777_()) || !ItemEditWidget.notYetInList(extraItem)) continue;
                allItems.add(extraItem);
            }
        }
    }

    private static boolean notYetInList(ItemStack stack) {
        return allItems.stream().noneMatch(s -> InventoryUtil.ItemMatches(s, stack));
    }

    @Nonnull
    private List<ItemStack> getFilteredItems() {
        if (this.listener.restrictItemEditItems()) {
            ItemTradeData trade = this.listener.getTrade();
            ItemTradeRestriction restriction = trade == null ? ItemTradeRestriction.NONE : trade.getRestriction();
            return this.getFilteredItems(restriction);
        }
        return allItems;
    }

    @Nonnull
    private List<ItemStack> getFilteredItems(ItemTradeRestriction restriction) {
        if (rebuilding) {
            return new ArrayList<ItemStack>();
        }
        ResourceLocation type = ItemTradeRestriction.getId(restriction);
        if (type == ItemTradeRestriction.NO_RESTRICTION_KEY && restriction != ItemTradeRestriction.NONE) {
            LightmansCurrency.LogWarning("Item Trade Restriction of class '" + restriction.getClass().getSimpleName() + "' was not registered, and is now being used to filter items.\nPlease register during the common setup so that this filtering can be done before the screen is opened to prevent in-game lag.");
            return allItems.stream().filter(restriction::allowItemSelectItem).collect(Collectors.toList());
        }
        if (!preFilteredItems.containsKey(type)) {
            LightmansCurrency.LogWarning("Item Trade Restriction of type '" + type + "' was registered AFTER the Player logged-in to the world. Please ensure that they're registered during the common setup phase so that filtering can be done at a less critical time.");
            preFilteredItems.put(type, allItems.stream().filter(restriction::allowItemSelectItem).collect(Collectors.toList()));
        }
        return preFilteredItems.get(type);
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.searchResultItems.size() - 1) / this.columns - this.rows + 1, 0);
    }

    public void refreshPage() {
        this.validateScroll();
        int startIndex = this.scroll * this.columns;
        for (int i = 0; i < this.rows * this.columns; ++i) {
            int thisIndex = startIndex + i;
            if (thisIndex >= this.searchResultItems.size()) continue;
            ItemStack stack = this.searchResultItems.get(thisIndex).m_41777_();
            stack.m_41764_(MathUtil.clamp(this.stackCount, 1, stack.m_41741_()));
        }
    }

    public void refreshSearch() {
        this.modifySearch(this.searchString);
    }

    public void modifySearch(@Nonnull String newSearch) {
        this.searchString = newSearch.toLowerCase();
        if (this.searchString.length() > 0) {
            this.searchResultItems = new ArrayList<ItemStack>();
            List<ItemStack> validItems = this.getFilteredItems();
            for (ItemStack stack : validItems) {
                if (stack.m_41786_().getString().toLowerCase().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                if (ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.m_41720_()).toString().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                AtomicReference<Boolean> enchantmentMatch = new AtomicReference<Boolean>(false);
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                enchantments.forEach((enchantment, level) -> {
                    if (ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)enchantment).toString().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    } else if (enchantment.m_44700_(level.intValue()).getString().toLowerCase().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    }
                });
                if (!enchantmentMatch.get().booleanValue()) continue;
                this.searchResultItems.add(stack);
            }
        } else {
            this.searchResultItems = this.getFilteredItems();
        }
        this.refreshPage();
    }

    @Override
    public void addChildren() {
        this.searchInput = this.addChild(new EditBox(this.font, this.getX() + this.searchOffX + 2, this.getY() + this.searchOffY + 2, 79, 9, this.getOldSearchInput(), (Component)EasyText.translatable("gui.lightmanscurrency.item_edit.search", new Object[0])));
        this.searchInput.m_94182_(false);
        this.searchInput.m_94199_(32);
        this.searchInput.m_94202_(0xFFFFFF);
        this.searchInput.m_94151_(this::modifySearch);
        this.stackScrollListener = this.addChild(new ScrollListener(this.getX() + this.stackSizeOffX, this.getY() + this.stackSizeOffY, 18, 18, this::stackCountScroll));
    }

    @Override
    protected void renderTick() {
        this.searchInput.f_93624_ = this.f_93624_;
        this.stackScrollListener.active = this.f_93624_;
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        if (!this.f_93624_) {
            return;
        }
        int index = this.scroll * this.columns;
        for (int y = 0; y < this.rows && index < this.searchResultItems.size(); ++y) {
            int yPos = y * 18;
            for (int x = 0; x < this.columns && index < this.searchResultItems.size(); ++index, ++x) {
                int xPos = x * 18;
                gui.resetColor();
                gui.blit(GUI_TEXTURE, xPos, yPos, 0, 0, 18, 18);
                gui.renderItem(this.getQuantityFixedStack(this.searchResultItems.get(index)), xPos + 1, yPos + 1);
            }
        }
        gui.resetColor();
        gui.blit(GUI_TEXTURE, this.searchOffX, this.searchOffY, 18, 0, 90, 12);
        gui.blit(GUI_TEXTURE, this.stackSizeOffX, this.stackSizeOffY, 108, 0, 18, 18);
    }

    public void tick() {
        this.searchInput.m_94120_();
    }

    private ItemStack getQuantityFixedStack(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(Math.min(stack.m_41741_(), this.stackCount));
        return copy;
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        if (!this.f_93624_) {
            return null;
        }
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultItems.size()) {
            return EasyScreenHelper.getTooltipFromItem(this.searchResultItems.get(hoveredSlot));
        }
        if (this.isMouseOverStackSizeScroll(mouseX, mouseY)) {
            return ImmutableList.of((Object)EasyText.translatable("tooltip.lightmanscurrency.item_edit.scroll", new Object[0]));
        }
        return null;
    }

    private boolean isMouseOverStackSizeScroll(int mouseX, int mouseY) {
        return mouseX >= this.getX() + this.stackSizeOffX && mouseX < this.getX() + this.stackSizeOffX + 18 && mouseY >= this.getY() + this.stackSizeOffY && mouseY < this.getY() + this.stackSizeOffY + 18;
    }

    private int isMouseOverSlot(double mouseX, double mouseY) {
        int foundColumn = -1;
        int foundRow = -1;
        for (int x = 0; x < this.columns && foundColumn < 0; ++x) {
            if (!(mouseX >= (double)(this.getX() + x * 18)) || !(mouseX < (double)(this.getX() + x * 18 + 18))) continue;
            foundColumn = x;
        }
        for (int y = 0; y < this.rows && foundRow < 0; ++y) {
            if (!(mouseY >= (double)(this.getY() + y * 18)) || !(mouseY < (double)(this.getY() + y * 18 + 18))) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * this.columns + foundColumn;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultItems.size()) {
            ItemStack stack = this.getQuantityFixedStack(this.searchResultItems.get(hoveredSlot));
            this.listener.onItemClicked(stack);
            return true;
        }
        return false;
    }

    public boolean stackCountScroll(double delta) {
        if (delta > 0.0) {
            if (this.stackCount < 64) {
                ++this.stackCount;
            }
        } else if (delta < 0.0 && this.stackCount > 1) {
            --this.stackCount;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (this.scroll >= this.getMaxScroll()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.refreshPage();
    }

    private static class ItemInsertRule {
        public final ItemStack insertStack;
        private final Predicate<ItemStack> afterItemCheck;
        private final Predicate<ItemStack> beforeItemCheck;
        private final Predicate<ItemStack> NULLCHECK = s -> false;

        private ItemInsertRule(ItemStack insertStack, @Nullable Predicate<ItemStack> afterItemCheck, @Nullable Predicate<ItemStack> beforeItemCheck) {
            this.insertStack = insertStack;
            this.afterItemCheck = afterItemCheck == null ? this.NULLCHECK : afterItemCheck;
            this.beforeItemCheck = beforeItemCheck == null ? this.NULLCHECK : beforeItemCheck;
        }

        public static ItemInsertRule atEnd(ItemStack insertStack) {
            return new ItemInsertRule(insertStack, null, null);
        }

        public static ItemInsertRule afterItem(ItemStack insertStack, @Nonnull Item item) {
            return new ItemInsertRule(insertStack, s -> s.m_41720_() == item, null);
        }

        public static ItemInsertRule afterCheck(ItemStack insertStack, @Nonnull Predicate<ItemStack> check) {
            return new ItemInsertRule(insertStack, check, null);
        }

        public static ItemInsertRule beforeItem(ItemStack insertStack, @Nonnull Item item) {
            return new ItemInsertRule(insertStack, null, s -> s.m_41720_() == item);
        }

        public static ItemInsertRule beforeCheck(ItemStack insertStack, @Nonnull Predicate<ItemStack> check) {
            return new ItemInsertRule(insertStack, null, check);
        }

        public boolean shouldInsertBefore(ItemStack insertedItem) {
            return this.beforeItemCheck.test(insertedItem);
        }

        public boolean shouldInsertAfter(ItemStack insertedItem) {
            return this.afterItemCheck.test(insertedItem);
        }

        public boolean shouldInsertAtEnd() {
            return this.afterItemCheck == this.NULLCHECK && this.beforeItemCheck == null;
        }
    }

    public static interface IItemEditListener {
        public ItemTradeData getTrade();

        public boolean restrictItemEditItems();

        public void onItemClicked(ItemStack var1);
    }
}

