/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.easy.IEasyTickable;
import io.github.lightman314.lightmanscurrency.common.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class TradeButtonArea
extends EasyWidgetWithChildren
implements IScrollable,
ITooltipSource,
IEasyTickable {
    public static final Function<TradeData, Boolean> FILTER_VALID = TradeData::isValid;
    public static final Function<TradeData, Boolean> FILTER_ANY = trade -> true;
    private final Supplier<? extends ITraderSource> traderSource;
    private final Function<TraderData, TradeContext> getContext;
    private BiFunction<TraderData, TradeData, Boolean> isSelected = (trader, trade) -> false;
    private InteractionConsumer interactionConsumer = null;
    private final List<TradeButton> allButtons = new ArrayList<TradeButton>();
    private final Font font;
    private final BiConsumer<TraderData, TradeData> onPress;
    private final Function<TradeData, Boolean> tradeFilter;
    private int scroll = 0;
    ScrollBarWidget scrollBar;
    private boolean hasTitlePosition = false;
    private ScreenPosition titlePosition = ScreenPosition.ZERO;
    private int titleWidth = 0;
    private boolean renderNameOnly = false;
    private ScreenPosition scrollBarOffset = ScreenPosition.of(-9, 0);
    private int scrollBarHeight;

    public void setSelectionDefinition(@Nonnull BiFunction<TraderData, TradeData, Boolean> isSelected) {
        this.isSelected = isSelected;
    }

    public void setInteractionConsumer(InteractionConsumer consumer) {
        this.interactionConsumer = consumer;
    }

    @Deprecated
    public ScrollBarWidget getScrollBar() {
        return this.scrollBar;
    }

    public TradeButtonArea withTitle(ScreenPosition titlePosition, int titleWidth, boolean renderNameOnly) {
        this.hasTitlePosition = true;
        this.titlePosition = titlePosition;
        this.titleWidth = titleWidth;
        this.renderNameOnly = renderNameOnly;
        return this;
    }

    public TradeButtonArea withScrollBarOffset(@Nonnull ScreenPosition scrollBarOffset) {
        this.scrollBarOffset = scrollBarOffset;
        return this;
    }

    public TradeButtonArea withScrollBarHeight(int height) {
        this.scrollBarHeight = height;
        return this;
    }

    public int getMinAvailableWidth() {
        return this.scrollBarOffset.x < 0 ? this.f_93618_ + this.scrollBarOffset.x : this.f_93618_;
    }

    public int getAvailableWidth() {
        return this.scrollBar.visible() ? (this.scrollBarOffset.x < 0 ? this.f_93618_ + this.scrollBarOffset.x : this.f_93618_) : this.f_93618_;
    }

    public TradeButtonArea(Supplier<? extends ITraderSource> traderSource, Function<TraderData, TradeContext> getContext, int x, int y, int width, int height, BiConsumer<TraderData, TradeData> onPress, Function<TradeData, Boolean> tradeFilter) {
        super(x, y, width, height);
        this.traderSource = traderSource;
        this.getContext = getContext;
        this.onPress = onPress;
        this.tradeFilter = tradeFilter;
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
        this.scrollBarHeight = this.f_93619_ - 5;
    }

    @Override
    public TradeButtonArea withAddons(WidgetAddon ... addons) {
        this.withAddonsInternal(addons);
        return this;
    }

    @Override
    public void addChildren() {
        this.scrollBar = new ScrollBarWidget(this.getX() + this.f_93618_ + this.scrollBarOffset.x, this.getY() + this.scrollBarOffset.y, this.scrollBarHeight, this);
        this.scrollBar = this.addChild(this.scrollBar);
        this.resetButtons();
    }

    @Nullable
    public TradeButton getHoveredButton(ScreenPosition mousePos) {
        for (TradeButton button : this.allButtons) {
            if (!button.m_5953_(mousePos.x, mousePos.y)) continue;
            return button;
        }
        return null;
    }

    public TraderData getTrader(int traderIndex) {
        ITraderSource source = this.traderSource.get();
        if (source == null) {
            return null;
        }
        List<TraderData> traders = source.getTraders();
        if (traderIndex < 0 || traderIndex >= traders.size()) {
            return null;
        }
        return traders.get(traderIndex);
    }

    public List<List<Pair<TraderData, TradeData>>> getTradesInRows() {
        ArrayList<List<Pair<TraderData, TradeData>>> result = new ArrayList<List<Pair<TraderData, TradeData>>>();
        List<TraderData> traders = this.traderSource.get().getTraders();
        int currentRowWidth = 0;
        ArrayList<Pair> currentRow = new ArrayList<Pair>();
        for (TraderData trader : traders) {
            TradeContext context = this.getContext.apply(trader);
            List<? extends TradeData> trades = trader.getTradeData();
            for (TradeData tradeData : trades) {
                if (!this.tradeFilter.apply(tradeData).booleanValue()) continue;
                TradeRenderManager<?> trm = tradeData.getButtonRenderer();
                int tradeWidth = trm.tradeButtonWidth(context);
                if (currentRowWidth + tradeWidth > this.getMinAvailableWidth() && currentRow.size() > 0) {
                    result.add(currentRow);
                    currentRow = new ArrayList();
                    currentRowWidth = 0;
                }
                currentRow.add(Pair.of((Object)trader, (Object)tradeData));
                currentRowWidth += tradeWidth;
            }
        }
        result.add(currentRow);
        return result;
    }

    public Pair<TraderData, TradeData> getTradeAndTrader(int displayIndex) {
        return this.getTradeAndTrader(this.scroll, displayIndex);
    }

    public Pair<TraderData, TradeData> getTradeAndTrader(int assumedScroll, int displayIndex) {
        ITraderSource source = this.traderSource.get();
        if (source == null) {
            return Pair.of(null, null);
        }
        List<List<Pair<TraderData, TradeData>>> rows = this.getTradesInRows();
        for (int r = assumedScroll; r < rows.size(); ++r) {
            List<Pair<TraderData, TradeData>> row = rows.get(r);
            for (Pair<TraderData, TradeData> traderDataTradeDataPair : row) {
                if (displayIndex <= 0) {
                    return traderDataTradeDataPair;
                }
                --displayIndex;
            }
        }
        return Pair.of(null, null);
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        if (this.validTrades() <= 0) {
            int textWidth = gui.font.m_92852_((FormattedText)EasyText.translatable("gui.lightmanscurrency.notrades", new Object[0]));
            MutableComponent mutableComponent = EasyText.translatable("gui.lightmanscurrency.notrades", new Object[0]);
            int n = this.f_93618_ / 2 - textWidth / 2;
            int n2 = this.f_93619_ / 2;
            Objects.requireNonNull(this.font);
            gui.drawString((Component)mutableComponent, n, n2 - 9 / 2, 0x404040);
        }
        if (this.hasTitlePosition) {
            ITraderSource ts = this.traderSource.get();
            if (ts == null) {
                return;
            }
            StringBuilder text = new StringBuilder();
            for (TraderData trader : ts.getTraders()) {
                if (text.length() == 0) {
                    text = new StringBuilder(this.renderNameOnly ? trader.getName().getString() : trader.getTitle().getString());
                    continue;
                }
                text.append(EasyText.translatable("gui.lightmanscurrency.trading.listseperator", new Object[0]).getString()).append(this.renderNameOnly ? trader.getName().getString() : trader.getTitle().getString());
            }
            gui.pushOffsetZero();
            gui.drawString(TextRenderUtil.fitString(text.toString(), this.titleWidth), this.titlePosition, 0x404040);
            gui.popOffset();
        }
    }

    @Override
    public void renderTick() {
        this.validateScroll();
    }

    @Override
    public void tick() {
        if (this.allButtons.size() < this.requiredButtons()) {
            this.resetButtons();
        } else {
            this.repositionButtons();
        }
    }

    private void resetButtons() {
        this.allButtons.forEach(x$0 -> this.removeChild(x$0));
        this.allButtons.clear();
        int requiredButtons = this.requiredButtons();
        int i = 0;
        while (i < requiredButtons) {
            int di = i++;
            TradeButton newButton = this.addChild(new TradeButton(() -> this.getContext.apply((TraderData)this.getTradeAndTrader(di).getFirst()), () -> (TradeData)this.getTradeAndTrader(di).getSecond(), button -> this.OnTraderPress(di)));
            this.allButtons.add(newButton);
        }
        this.repositionButtons();
    }

    private int validTrades() {
        ITraderSource ts = this.traderSource.get();
        if (ts == null) {
            return 0;
        }
        int count = 0;
        List<TraderData> traders = ts.getTraders();
        for (TraderData trader : traders) {
            List<? extends TradeData> trades = trader.getTradeData();
            for (TradeData tradeData : trades) {
                if (tradeData == null || !this.tradeFilter.apply(tradeData).booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    private int requiredButtons() {
        List<List<Pair<TraderData, TradeData>>> rows = this.getTradesInRows();
        int count = 0;
        int lines = this.fittableLines();
        for (int r = this.scroll; r < rows.size() && r < this.scroll + lines; ++r) {
            count += rows.get(r).size();
        }
        return count;
    }

    private int fittableLines() {
        return this.f_93619_ / 22;
    }

    private void repositionButtons() {
        int displayIndex = 0;
        int yOffset = 0;
        int fittableLines = this.fittableLines();
        List<List<Pair<TraderData, TradeData>>> rows = this.getTradesInRows();
        for (int line = 0; line < fittableLines && line + this.scroll < rows.size(); ++line) {
            int spacing;
            List<Pair<TraderData, TradeData>> row = rows.get(line + this.scroll);
            int visibleButtons = 0;
            int totalWidth = 0;
            for (Pair<TraderData, TradeData> trade : row) {
                if (trade.getFirst() == null || trade.getSecond() == null) continue;
                TradeContext context = this.getContext.apply((TraderData)trade.getFirst());
                ++visibleButtons;
                totalWidth += ((TradeData)trade.getSecond()).getButtonRenderer().tradeButtonWidth(context);
            }
            int xOffset = spacing = (this.getAvailableWidth() - totalWidth) / (visibleButtons + 1);
            for (Pair<TraderData, TradeData> trade : row) {
                TradeButton button = this.allButtons.get(displayIndex);
                if (trade.getFirst() != null && trade.getSecond() != null) {
                    TradeContext context = this.getContext.apply((TraderData)trade.getFirst());
                    button.setPosition(this.getPosition().offset(xOffset, yOffset));
                    button.f_93624_ = true;
                    button.f_93623_ = this.isSelected.apply((TraderData)trade.getFirst(), (TradeData)trade.getSecond()) == false;
                    xOffset += ((TradeData)trade.getSecond()).getButtonRenderer().tradeButtonWidth(context) + spacing;
                } else {
                    button.f_93624_ = false;
                }
                ++displayIndex;
            }
            yOffset += 22;
        }
        for (int i = displayIndex; i < this.allButtons.size(); ++i) {
            this.allButtons.get((int)i).f_93624_ = false;
        }
    }

    private void OnTraderPress(int displayIndex) {
        if (this.onPress != null) {
            Pair<TraderData, TradeData> data = this.getTradeAndTrader(displayIndex);
            this.onPress.accept((TraderData)data.getFirst(), (TradeData)data.getSecond());
        }
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        if (this.hasTitlePosition) {
            Objects.requireNonNull(this.font);
            if (this.titlePosition.isMouseInArea(mouseX, mouseY, this.titleWidth, 9)) {
                ArrayList<Component> tooltips = new ArrayList<Component>();
                ITraderSource ts = this.traderSource.get();
                if (ts == null) {
                    return null;
                }
                for (TraderData trader : ts.getTraders()) {
                    tooltips.add((Component)trader.getTitle());
                }
                return tooltips;
            }
        }
        return null;
    }

    private boolean canScrollDown() {
        return this.canScrollDown(this.scroll);
    }

    private boolean canScrollDown(int assumedScroll) {
        return this.getTradesInRows().size() - assumedScroll > this.fittableLines();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            this.resetButtons();
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
            this.resetButtons();
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.allButtons.size(); ++i) {
            TradeButton b = this.allButtons.get(i);
            if (!b.m_5953_(mouseX, mouseY)) continue;
            Pair<TraderData, TradeData> traderPair = this.getTradeAndTrader(i);
            TradeContext context = this.getContext.apply((TraderData)traderPair.getFirst());
            if (context.isStorageMode) {
                if (this.interactionConsumer == null) continue;
                b.onInteractionClick((int)mouseX, (int)mouseY, button, this.interactionConsumer);
                return true;
            }
            return b.m_6375_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        if (newScroll == this.scroll) {
            return;
        }
        this.scroll = MathUtil.clamp(newScroll, 0, this.getMaxScroll());
        this.resetButtons();
    }

    @Override
    public int getMaxScroll() {
        int s = 0;
        while (this.canScrollDown(s)) {
            ++s;
        }
        return s;
    }

    public static interface InteractionConsumer {
        public void onTradeButtonInputInteraction(TraderData var1, TradeData var2, int var3, int var4);

        public void onTradeButtonOutputInteraction(TraderData var1, TradeData var2, int var3, int var4);

        public void onTradeButtonInteraction(TraderData var1, TradeData var2, int var3, int var4, int var5);
    }
}

