/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.atm.ATMExchangeButtonData;
import io.github.lightman314.lightmanscurrency.common.atm.ATMIconData;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class ATMExchangeButton
extends EasyButton {
    public static final int HEIGHT = 18;
    public final ATMExchangeButtonData data;
    public boolean selected = false;

    public ATMExchangeButton(ScreenPosition corner, ATMExchangeButtonData data, Consumer<String> commandHandler) {
        super(corner.offset(data.position), data.width, 18, (EasyButton b) -> commandHandler.accept(data.command));
        this.data = data;
    }

    public ATMExchangeButton withAddons(WidgetAddon ... addons) {
        this.withAddonsInternal(addons);
        return this;
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        int xSize;
        int yOffset;
        int n = yOffset = this.f_93622_ != this.selected ? 18 : 0;
        if (this.f_93623_) {
            gui.resetColor();
        } else {
            gui.setColor(0.5f, 0.5f, 0.5f);
        }
        gui.blit(ATMScreen.BUTTON_TEXTURE, 0, 0, 0, yOffset, 2, 18);
        for (int xPos = 2; xPos < this.m_5711_() - 2; xPos += xSize) {
            xSize = Math.min(this.m_5711_() - 2 - xPos, 252);
            gui.blit(ATMScreen.BUTTON_TEXTURE, xPos, 0, 2, yOffset, xSize, 18);
        }
        gui.blit(ATMScreen.BUTTON_TEXTURE, this.m_5711_() - 2, 0, 254, yOffset, 2, 18);
        for (ATMIconData icon : this.data.getIcons()) {
            try {
                icon.render(this, gui, this.f_93622_);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error rendering ATM Conversion Button icon.", t);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

