/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.data.ClientNotificationData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NotificationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.InventoryButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.util.NonNullSupplier;

public class NotificationButton
extends InventoryButton {
    private static NotificationButton lastButton = null;
    public static final int SIZE = 9;
    public static final ScreenPosition OFFSET = ScreenPosition.of(10, 0);
    public static final Sprite SPRITE_NORMAL = Sprite.SimpleSprite(NotificationScreen.GUI_TEXTURE, 200, 0, 9, 9);
    public static final Sprite SPRITE_UNSEEN = Sprite.SimpleSprite(NotificationScreen.GUI_TEXTURE, 209, 0, 9, 9);

    public NotificationButton(AbstractContainerScreen<?> inventoryScreen) {
        super(inventoryScreen, (EasyButton button) -> LightmansCurrency.PROXY.openNotificationScreen(), (NonNullSupplier<Sprite>)((NonNullSupplier)NotificationButton::getSprite));
        lastButton = this;
    }

    @Override
    protected ScreenPosition getPositionOffset(boolean isCreativeScreen) {
        return isCreativeScreen ? Config.CLIENT.notificationAndTeamButtonCreativePosition.get().offset(OFFSET) : Config.CLIENT.notificationAndTeamButtonPosition.get().offset(OFFSET);
    }

    private static Sprite getSprite() {
        return ClientNotificationData.GetNotifications().unseenNotification() ? SPRITE_UNSEEN : SPRITE_NORMAL;
    }

    public static void tryRenderTooltip(EasyGuiGraphics gui) {
        if (lastButton != null && lastButton.isMouseOver(gui.mousePos)) {
            gui.renderTooltip((Component)EasyText.translatable("tooltip.button.notification", new Object[0]));
        }
    }
}

