/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertType;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlertData {
    private final MutableComponent message;
    public final AlertType type;

    private AlertData(MutableComponent message, AlertType type) {
        this.message = message;
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setShaderColor(EasyGuiGraphics gui, float mult) {
        float red = (float)(this.type.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.type.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.type.color & 0xFF) / 255.0f;
        gui.setColor(red * mult, green * mult, blue * mult);
    }

    public MutableComponent getFormattedMessage() {
        return this.message.m_130938_(this.type.format);
    }

    public static int compare(AlertData a, AlertData b) {
        return Integer.compare(a.type.priority, b.type.priority) * -1;
    }

    public static AlertData helpful(@Nonnull MutableComponent message) {
        return AlertData.of(message, AlertType.HELPFUL);
    }

    public static AlertData warn(@Nonnull MutableComponent message) {
        return AlertData.of(message, AlertType.WARN);
    }

    public static AlertData error(@Nonnull MutableComponent message) {
        return AlertData.of(message, AlertType.ERROR);
    }

    private static AlertData of(@Nonnull MutableComponent message, @Nonnull AlertType type) {
        return new AlertData(message, type);
    }
}

