/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.easy;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;

public abstract class EasyWidget
extends AbstractWidget {
    private ScreenArea area;
    private final List<WidgetAddon> addons = new ArrayList<WidgetAddon>();
    private boolean lockAddons = false;

    public final ScreenArea getArea() {
        return this.area;
    }

    public final int getX() {
        return this.area.x;
    }

    public final void setX(int x) {
        this.area = this.area.atPosition(ScreenPosition.of(x, this.area.y));
    }

    public final int getY() {
        return this.area.y;
    }

    public final void setY(int y) {
        this.area = this.area.atPosition(ScreenPosition.of(this.area.x, y));
    }

    public final ScreenPosition getPosition() {
        return this.area.pos;
    }

    public final void setPosition(int x, int y) {
        this.area = this.area.atPosition(x, y);
    }

    public final void setPosition(@Nonnull ScreenPosition pos) {
        this.area = this.area.atPosition(pos);
    }

    public final int m_5711_() {
        return this.area.width;
    }

    public final int m_93694_() {
        return this.area.height;
    }

    public final void m_93674_(int width) {
        this.area = this.area.ofSize(width, this.area.height);
        super.m_93674_(width);
    }

    public final void setHeight(int height) {
        this.area = this.area.ofSize(this.area.width, height);
        super.setHeight(height);
    }

    public final void setSize(int width, int height) {
        this.area = this.area.ofSize(width, height);
        super.m_93674_(width);
        super.setHeight(height);
    }

    public final boolean isVisible() {
        this.visibleTickInternal();
        return this.f_93624_;
    }

    public final void setVisible(boolean visible) {
        this.f_93624_ = visible;
    }

    public final boolean m_142518_() {
        this.activeTickInternal();
        return super.m_142518_();
    }

    public final void setActive(boolean active) {
        this.f_93623_ = active;
    }

    public final boolean isMouseOver(ScreenPosition mousePos) {
        return this.m_5953_(mousePos.x, mousePos.y);
    }

    protected EasyWidget(int x, int y, int width, int height) {
        this(ScreenArea.of(ScreenPosition.of(x, y), width, height));
    }

    protected EasyWidget(int x, int y, int width, int height, Component title) {
        this(ScreenArea.of(ScreenPosition.of(x, y), width, height), title);
    }

    protected EasyWidget(ScreenPosition position, int width, int height) {
        this(ScreenArea.of(position, width, height));
    }

    protected EasyWidget(ScreenPosition position, int width, int height, Component title) {
        this(ScreenArea.of(position, width, height), title);
    }

    protected EasyWidget(ScreenArea area) {
        this(area, (Component)EasyText.empty());
    }

    protected EasyWidget(ScreenArea area, Component title) {
        super(area.x, area.y, area.width, area.height, title);
        this.area = area;
    }

    public abstract Object withAddons(WidgetAddon ... var1);

    protected final void withAddonsInternal(WidgetAddon ... addons) {
        if (this.lockAddons) {
            return;
        }
        for (WidgetAddon a : addons) {
            if (a == null || this.addons.contains(a)) continue;
            this.addons.add(a);
            a.attach(this);
        }
    }

    public final void addAddons(Consumer<WidgetAddon> consumer) {
        this.lockAddons = true;
        for (WidgetAddon addon : this.addons) {
            consumer.accept(addon);
        }
    }

    public void removeAddons(Consumer<WidgetAddon> consumer) {
        for (WidgetAddon addon : this.addons) {
            consumer.accept(addon);
        }
    }

    public final void m_6305_(@Nonnull PoseStack pose, int mouseX, int mouseY, float partialTick) {
        this.renderTickInternal();
        super.m_6305_(pose, mouseX, mouseY, partialTick);
    }

    private void visibleTickInternal() {
        this.addons.forEach(WidgetAddon::visibleTick);
    }

    private void activeTickInternal() {
        this.visibleTickInternal();
        this.addons.forEach(WidgetAddon::activeTick);
    }

    private void renderTickInternal() {
        this.activeTickInternal();
        this.addons.forEach(WidgetAddon::renderTick);
        this.renderTick();
        this.f_93620_ = this.area.x;
        this.f_93621_ = this.area.y;
    }

    protected void renderTick() {
    }

    public final void m_6303_(@Nonnull PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.renderWidget(EasyGuiGraphics.create(pose, mouseX, mouseY, partialTicks).pushOffset(this.getPosition()));
    }

    protected abstract void renderWidget(@Nonnull EasyGuiGraphics var1);

    protected boolean m_7972_(int button) {
        return false;
    }

    public void m_7435_(@Nonnull SoundManager manager) {
    }

    public void m_142291_(@Nonnull NarrationElementOutput narrator) {
    }
}

