/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.slot_machine;

import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine.SlotMachineEntryClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.easy.IEasyTickable;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachineEntryTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class SlotMachineEntryEditWidget
extends EasyWidgetWithChildren
implements IEasyTickable,
ITooltipSource {
    public static final int WIDTH = 80;
    public static final int HEIGHT = 46;
    public final SlotMachineEntryClientTab tab;
    public final Supplier<Integer> entryIndex;
    private EditBox weightEdit;
    private PlainButton removeEntryButton;
    private int previousIndex = -1;
    private static final int ITEM_POSY = 22;

    public SlotMachineEntryEditWidget(ScreenPosition pos, SlotMachineEntryClientTab tab, Supplier<Integer> entryIndex) {
        this(pos.x, pos.y, tab, entryIndex);
    }

    public SlotMachineEntryEditWidget(int x, int y, SlotMachineEntryClientTab tab, Supplier<Integer> entryIndex) {
        super(x, y, 80, 46);
        this.tab = tab;
        this.entryIndex = entryIndex;
    }

    @Override
    public SlotMachineEntryEditWidget withAddons(WidgetAddon ... addons) {
        this.withAddonsInternal(addons);
        return this;
    }

    @Override
    public void addChildren() {
        this.weightEdit = this.addChild(new EditBox(this.tab.getFont(), this.getX() + this.tab.getFont().m_92852_((FormattedText)EasyText.translatable("gui.lightmanscurrency.trader.slot_machine.weight_label", new Object[0])), this.getY() + 10, 36, 10, (Component)EasyText.empty()));
        this.weightEdit.m_94199_(4);
        this.removeEntryButton = this.addChild(IconAndButtonUtil.minusButton(this.getX(), this.getY(), this::Remove));
    }

    private SlotMachineEntry getEntry() {
        return this.tab.getEntry(this.entryIndex.get());
    }

    private void Remove(EasyButton button) {
        ((SlotMachineEntryTab)this.tab.commonTab).RemoveEntry(this.entryIndex.get());
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        SlotMachineEntry entry = this.getEntry();
        if (entry != null) {
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.trader.slot_machine.entry_label", this.entryIndex.get() + 1), 12, 0, 0x404040);
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.trader.slot_machine.weight_label", new Object[0]), 0, 12, 0x404040);
            for (int i = 0; i < 4; ++i) {
                if (i < entry.items.size() && !entry.items.get(i).m_41619_()) {
                    gui.renderItem(entry.items.get(i), 18 * i, 22);
                    continue;
                }
                gui.renderSlotBackground(EasySlot.BACKGROUND, 18 * i, 22);
            }
        }
    }

    @Override
    protected boolean m_7972_(int button) {
        return button == 0 || button == 1;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_93680_(mouseX, mouseY) && this.m_7972_(button)) {
            boolean rightClick = button == 1;
            SlotMachineEntry entry = this.getEntry();
            if (entry != null) {
                int itemIndex;
                int entryIndex = this.entryIndex.get();
                ItemStack heldItem = this.tab.menu.m_142621_();
                if (mouseY >= (double)(this.getY() + 22) && mouseY < (double)(this.getY() + 22 + 16) && (itemIndex = this.getItemSlotIndex(mouseX)) >= 0) {
                    if (itemIndex >= entry.items.size()) {
                        if (!heldItem.m_41619_()) {
                            if (rightClick) {
                                ((SlotMachineEntryTab)this.tab.commonTab).AddEntryItem(entryIndex, InventoryUtil.copyWithCount(heldItem, 1));
                            } else {
                                ((SlotMachineEntryTab)this.tab.commonTab).AddEntryItem(entryIndex, heldItem);
                            }
                            return true;
                        }
                    } else {
                        if (heldItem.m_41619_()) {
                            if (rightClick) {
                                ItemStack newStack = entry.items.get(itemIndex).m_41777_();
                                newStack.m_41774_(1);
                                if (newStack.m_41619_()) {
                                    ((SlotMachineEntryTab)this.tab.commonTab).RemoveEntryItem(entryIndex, itemIndex);
                                } else {
                                    ((SlotMachineEntryTab)this.tab.commonTab).EditEntryItem(entryIndex, itemIndex, newStack);
                                }
                            } else {
                                ((SlotMachineEntryTab)this.tab.commonTab).RemoveEntryItem(entryIndex, itemIndex);
                            }
                            return true;
                        }
                        if (rightClick) {
                            ItemStack oldStack = entry.items.get(itemIndex);
                            if (InventoryUtil.ItemMatches(heldItem, oldStack)) {
                                ItemStack newStack = entry.items.get(itemIndex).m_41777_();
                                if (newStack.m_41613_() >= newStack.m_41741_()) {
                                    return false;
                                }
                                newStack.m_41769_(1);
                                ((SlotMachineEntryTab)this.tab.commonTab).EditEntryItem(entryIndex, itemIndex, newStack);
                            } else {
                                ((SlotMachineEntryTab)this.tab.commonTab).EditEntryItem(entryIndex, itemIndex, InventoryUtil.copyWithCount(heldItem, 1));
                            }
                            return true;
                        }
                        ((SlotMachineEntryTab)this.tab.commonTab).EditEntryItem(entryIndex, itemIndex, heldItem);
                    }
                }
            }
        }
        return false;
    }

    private int getItemSlotIndex(double mouseX) {
        int x = (int)mouseX - this.getX();
        if (x < 0) {
            return -1;
        }
        int result = x / 18;
        return result >= 4 ? -1 : result;
    }

    @Override
    public void tick() {
        TraderData traderData;
        SlotMachineEntry entry = this.getEntry();
        if (entry != null && (traderData = this.tab.menu.getTrader()) instanceof SlotMachineTraderData) {
            int newWeight;
            boolean hasPerms;
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            this.weightEdit.f_93624_ = true;
            this.removeEntryButton.f_93624_ = hasPerms = this.tab.menu.hasPermission("editTrades");
            this.weightEdit.m_94186_(hasPerms);
            if (trader.areEntriesChanged()) {
                this.weightEdit.m_94144_(Integer.toString(entry.getWeight()));
                return;
            }
            int thisIndex = this.entryIndex.get();
            if (thisIndex != this.previousIndex) {
                this.weightEdit.m_94144_(Integer.toString(entry.getWeight()));
            }
            if ((newWeight = TextInputUtil.getIntegerValue(this.weightEdit, 1)) != entry.getWeight()) {
                ((SlotMachineEntryTab)this.tab.commonTab).ChangeEntryWeight(thisIndex, newWeight);
            }
            this.previousIndex = thisIndex;
        } else {
            this.removeEntryButton.f_93624_ = false;
            this.weightEdit.f_93624_ = false;
        }
        TextInputUtil.whitelistInteger(this.weightEdit, 1L, 1000L);
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        ItemStack item;
        int itemIndex;
        SlotMachineEntry entry = this.getEntry();
        if (entry != null && mouseY >= this.getY() + 22 && mouseY < this.getY() + 22 + 16 && (itemIndex = this.getItemSlotIndex(mouseX)) >= 0 && itemIndex < entry.items.size() && !(item = entry.items.get(itemIndex)).m_41619_()) {
            return EasyScreenHelper.getTooltipFromItem(item);
        }
        return null;
    }
}

