/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.ItemPositionBlockManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.ItemPositionData;
import io.github.lightman314.lightmanscurrency.common.blockentity.AuctionStandBlockEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class AuctionStandBlockEntityRenderer
implements BlockEntityRenderer<AuctionStandBlockEntity> {
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();

    public AuctionStandBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(@NotNull AuctionStandBlockEntity blockEntity, float partialTicks, @NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int lightLevel, int id) {
        ImmutableList<ItemStack> displayItems = AuctionStandBlockEntity.getDisplayItems();
        if (displayItems.size() < 1) {
            return;
        }
        BlockState state = blockEntity.m_58900_();
        ItemPositionData data = ItemPositionBlockManager.getDataForBlock(state);
        List<Vector3f> positions = data.getPositions(state, 0);
        if (positions.size() == 0) {
            return;
        }
        pose.m_85836_();
        Vector3f pos = positions.get(0);
        pose.m_85837_((double)pos.m_122239_(), (double)pos.m_122260_(), (double)pos.m_122269_());
        for (Quaternion r : data.getRotation(state, 0, partialTicks)) {
            pose.m_85845_(r);
        }
        float scale = data.getScale(0);
        pose.m_85841_(scale, scale, scale);
        if (displayItems.size() < 2) {
            this.itemRenderer.m_174269_((ItemStack)displayItems.get(0), ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, id);
        } else {
            pose.m_85836_();
            pose.m_85837_((double)-0.55f, 0.0, 0.0);
            this.itemRenderer.m_174269_((ItemStack)displayItems.get(0), ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, id);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_85837_((double)0.55f, 0.0, 0.0);
            this.itemRenderer.m_174269_((ItemStack)displayItems.get(1), ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, id);
            pose.m_85849_();
        }
        pose.m_85849_();
    }
}

