/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.BookRenderer;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.BookTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BookTraderBlockEntityRenderer
implements BlockEntityRenderer<BookTraderBlockEntity> {
    public BookTraderBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(@Nonnull BookTraderBlockEntity blockEntity, float partialTicks, @NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int lightLevel, int id) {
        ItemTraderData trader = (ItemTraderData)blockEntity.getTraderData();
        if (trader == null) {
            return;
        }
        for (int tradeSlot = 0; tradeSlot < trader.getTradeCount() && tradeSlot < blockEntity.maxRenderIndex(); ++tradeSlot) {
            BookRenderer renderer;
            ItemTradeData trade = trader.getTrade(tradeSlot);
            if (!trade.hasStock(trader) || (renderer = BookTraderBlockEntityRenderer.GetRenderer(ItemTraderBlockEntityRenderer.GetRenderItems(trade))) == null) continue;
            pose.m_85836_();
            Vector3f offset = blockEntity.GetBookRenderPos(tradeSlot);
            List<Quaternion> rotations = blockEntity.GetBookRenderRot(tradeSlot);
            float scale = blockEntity.GetBookRenderScale(tradeSlot);
            pose.m_85837_((double)offset.m_122239_(), (double)offset.m_122260_(), (double)offset.m_122269_());
            for (Quaternion r : rotations) {
                pose.m_85845_(r);
            }
            pose.m_85841_(scale, scale, scale);
            renderer.render(blockEntity, partialTicks, pose, buffer, lightLevel, id);
            pose.m_85849_();
        }
    }

    private static BookRenderer GetRenderer(List<ItemStack> renderItems) {
        for (ItemStack book : renderItems) {
            BookRenderer renderer = BookRenderer.GetRenderer(book);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }
}

