/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.ItemPositionData;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ItemTraderBlockEntityRenderer
implements BlockEntityRenderer<ItemTraderBlockEntity> {
    private static long rotationTime = 0L;

    public ItemTraderBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(@NotNull ItemTraderBlockEntity blockEntity, float partialTicks, @NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int lightLevel, int id) {
        ItemTraderBlockEntityRenderer.renderItems(blockEntity, partialTicks, pose, buffer, lightLevel, id);
    }

    public static List<ItemStack> GetRenderItems(ItemTradeData trade) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = trade.getSellItem(i);
            if (item.m_41619_()) continue;
            result.add(item);
        }
        return result;
    }

    public static void renderItems(ItemTraderBlockEntity blockEntity, float partialTicks, PoseStack pose, MultiBufferSource buffer, int lightLevel, int id) {
        try {
            TraderData rawTrader = blockEntity.getRawTraderData();
            if (!(rawTrader instanceof ItemTraderData)) {
                return;
            }
            ItemTraderData trader = (ItemTraderData)rawTrader;
            ItemPositionData positionData = blockEntity.GetRenderData();
            int maxIndex = positionData.isEmpty() ? blockEntity.maxRenderIndex() : positionData.getEntryCount();
            int renderLimit = (Integer)Config.CLIENT.itemRenderLimit.get();
            BlockState state = blockEntity.m_58900_();
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            for (int tradeSlot = 0; tradeSlot < trader.getTradeCount() && tradeSlot < maxIndex; ++tradeSlot) {
                ItemTradeData trade = trader.getTrade(tradeSlot);
                List<ItemStack> renderItems = ItemTraderBlockEntityRenderer.GetRenderItems(trade);
                if (renderItems.size() <= 0) continue;
                List<Vector3f> positions = positionData.isEmpty() ? blockEntity.GetStackRenderPos(tradeSlot, renderItems.size() > 1) : positionData.getPositions(state, tradeSlot);
                List<Quaternion> rotation = positionData.isEmpty() ? blockEntity.GetStackRenderRot(tradeSlot, partialTicks) : positionData.getRotation(state, tradeSlot, partialTicks);
                float scale = positionData.isEmpty() ? blockEntity.GetStackRenderScale(tradeSlot) : positionData.getScale(tradeSlot);
                for (int pos = 0; pos < renderLimit && pos < positions.size() && pos < trader.getTradeStock(tradeSlot); ++pos) {
                    pose.m_85836_();
                    Vector3f position = positions.get(pos);
                    pose.m_85837_((double)position.m_122239_(), (double)position.m_122260_(), (double)position.m_122269_());
                    for (Quaternion rot : rotation) {
                        pose.m_85845_(rot);
                    }
                    pose.m_85841_(scale, scale, scale);
                    if (renderItems.size() > 1) {
                        pose.m_85836_();
                        pose.m_85837_(0.25, 0.25, 0.0);
                        pose.m_85841_(0.5f, 0.5f, 0.5f);
                        itemRenderer.m_174269_(renderItems.get(0), ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, id);
                        pose.m_85849_();
                        pose.m_85836_();
                        pose.m_85837_(-0.25, -0.25, 0.001);
                        pose.m_85841_(0.5f, 0.5f, 0.5f);
                        itemRenderer.m_174269_(renderItems.get(1), ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, id);
                        pose.m_85849_();
                    } else {
                        itemRenderer.m_174269_(renderItems.get(0), ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, id);
                    }
                    pose.m_85849_();
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering an Item Trader!", t);
        }
    }

    public static long getRotationTime() {
        return rotationTime;
    }

    public static Quaternion getRotation(float partialTicks) {
        return Vector3f.f_122225_.m_122240_(((float)ItemTraderBlockEntityRenderer.getRotationTime() + partialTicks) * 2.0f);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++rotationTime;
        }
    }
}

