/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.SlotMachineTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.SlotMachineBlock;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SlotMachineBlockEntityRenderer
implements BlockEntityRenderer<SlotMachineTraderBlockEntity> {
    public SlotMachineBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public int m_142163_() {
        return 256;
    }

    public void render(@NotNull SlotMachineTraderBlockEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int lightLevel, int overlay) {
        Block block = tileEntity.m_58900_().m_60734_();
        if (block instanceof SlotMachineBlock) {
            SlotMachineBlock block2 = (SlotMachineBlock)block;
            ResourceLocation lightModel = block2.getLightModel();
            if (lightModel == null) {
                return;
            }
            poseStack.m_85836_();
            Direction facing = block2.getFacing(tileEntity.m_58900_());
            Vector3f corner = IRotatableBlock.getOffsetVect(facing);
            Vector3f right = IRotatableBlock.getRightVect(facing);
            Vector3f forward = IRotatableBlock.getForwardVect(facing);
            Vector3f offset = MathUtil.VectorAdd(corner, MathUtil.VectorMult(right, 0.5f), MathUtil.VectorMult(forward, 0.5f), new Vector3f(0.0f, 0.5f, 0.0f));
            poseStack.m_85837_((double)offset.m_122239_(), (double)offset.m_122260_(), (double)offset.m_122269_());
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)facing.m_122416_() * -90.0f));
            Minecraft mc = Minecraft.m_91087_();
            BakedModel model = mc.m_91304_().getModel(lightModel);
            ItemRenderer itemRenderer = mc.m_91291_();
            itemRenderer.m_115143_(new ItemStack((ItemLike)block2), ItemTransforms.TransformType.FIXED, false, poseStack, bufferSource, 0xF000F0, OverlayTexture.f_118083_, model);
            poseStack.m_85849_();
        }
    }
}

