/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.ItemPositionBlockManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.ItemPositionManager;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.resource.PathResourcePack;

@Mod.EventBusSubscriber(modid="lightmanscurrency", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LCResourcePacks {
    private static final List<CustomResourcePack> packList = new ArrayList<CustomResourcePack>();
    public static final CustomResourcePack RUPEE_PACK = LCResourcePacks.registerPack("lightmanscurrency", "RupeePack", (Component)EasyText.translatable("resourcepack.lightmanscurrency.rupees", new Object[0]));
    public static final CustomResourcePack FANCY_ITEMS_PACK = LCResourcePacks.registerPack("lightmanscurrency", "CloserItemsPack", (Component)EasyText.translatable("resourcepack.lightmanscurrency.closer_items", new Object[0]));

    private LCResourcePacks() {
    }

    @Nonnull
    public static CustomResourcePack registerPack(@Nonnull String modid, @Nonnull String path, @Nonnull Component name) {
        return LCResourcePacks.registerPack(new CustomResourcePack(modid, path, name));
    }

    @Nonnull
    public static CustomResourcePack registerPack(@Nonnull CustomResourcePack pack) {
        if (packList.contains(pack)) {
            return pack;
        }
        packList.add(pack);
        return pack;
    }

    @SubscribeEvent
    public static void registerPackSource(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        for (CustomResourcePack pack : packList) {
            event.addRepositorySource((RepositorySource)pack);
        }
    }

    @SubscribeEvent
    public static void registerResourceListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ItemPositionManager.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)ItemPositionBlockManager.INSTANCE);
    }

    public static class CustomResourcePack
    implements RepositorySource {
        private final String modid;
        private final String path;
        private final Component name;

        public CustomResourcePack(@Nonnull String modid, @Nonnull String path, @Nonnull Component name) {
            this.modid = modid;
            this.path = path;
            this.name = name;
        }

        public void m_7686_(@Nonnull Consumer<Pack> consumer, @Nonnull Pack.PackConstructor constructor) {
            Path resourcePath = ModList.get().getModFileById(this.modid).getFile().findResource(new String[]{this.path});
            PathResourcePack resources = new PathResourcePack(this.name.getString(), resourcePath);
            Pack pack = Pack.m_10430_((String)("builtin/" + this.path), (boolean)false, () -> resources, (Pack.PackConstructor)constructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            if (pack == null) {
                LightmansCurrency.LogWarning("Custom Resource Pack of '" + this.modid + "/" + this.path + " failed to load properly!");
            } else {
                consumer.accept(pack);
            }
        }
    }
}

