/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.atm;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm.ATMExchangeButton;
import io.github.lightman314.lightmanscurrency.common.atm.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.common.atm.icons.SimpleArrowIcon;
import io.github.lightman314.lightmanscurrency.common.atm.icons.SpriteIcon;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ATMIconData {
    private static Map<String, IconType> REGISTERED_TYPES = null;
    private static boolean initialized = false;
    protected final int xPos;
    protected final int yPos;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        LightmansCurrency.LogInfo("Collecting ATM Icon Types");
        REGISTERED_TYPES = new HashMap<String, IconType>();
        ATMIconData.register(ItemIcon.TYPE);
        ATMIconData.register(SimpleArrowIcon.TYPE);
        ATMIconData.register(SpriteIcon.TYPE);
    }

    public static void register(IconType iconType) {
        String type;
        if (!initialized) {
            ATMIconData.init();
        }
        if (REGISTERED_TYPES.containsKey(type = iconType.type.toString())) {
            if (REGISTERED_TYPES.get(type) == iconType) {
                LightmansCurrency.LogWarning("ATM Icon Type '" + type + "' was registered twice.");
            } else {
                LightmansCurrency.LogWarning("Attempted to register an ATM Icon Type of type '" + type + "', but an ATM Icon of that type is already registered.");
            }
        }
        REGISTERED_TYPES.put(type, iconType);
        LightmansCurrency.LogInfo("ATM Icon Type '" + type + "' has been registered successfully.");
    }

    protected ATMIconData(JsonObject data) throws RuntimeException {
        this.xPos = data.get("x").getAsInt();
        this.yPos = data.get("y").getAsInt();
    }

    protected ATMIconData(int xPos, int yPos) {
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public final JsonObject save() {
        JsonObject data = new JsonObject();
        data.addProperty("type", this.getType().toString());
        data.addProperty("x", (Number)this.xPos);
        data.addProperty("y", (Number)this.yPos);
        this.saveAdditional(data);
        return data;
    }

    protected abstract ResourceLocation getType();

    protected abstract void saveAdditional(JsonObject var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(@Nonnull ATMExchangeButton var1, @Nonnull EasyGuiGraphics var2, boolean var3);

    public static ATMIconData parse(JsonObject data) throws Exception {
        if (data.has("type")) {
            String type = data.get("type").getAsString();
            if (REGISTERED_TYPES.containsKey(type)) {
                return REGISTERED_TYPES.get(type).parse(data);
            }
            throw new Exception("No ATM Icon of type '" + type + "'. Unable to parse.");
        }
        throw new Exception("ATM Icon data has no 'type' entry. Unable to parse.");
    }

    public static final class IconType {
        public final ResourceLocation type;
        private final Function<JsonObject, ATMIconData> deserializer;

        public boolean matches(String type) {
            return this.type.toString().equals(type);
        }

        public ATMIconData parse(JsonObject data) {
            return this.deserializer.apply(data);
        }

        private IconType(ResourceLocation type, Function<JsonObject, ATMIconData> deserializer) {
            this.type = type;
            this.deserializer = deserializer;
        }

        public static IconType create(ResourceLocation type, Function<JsonObject, ATMIconData> deserializer) {
            return new IconType(type, deserializer);
        }
    }
}

