/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.bank;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.common.bank.interfaces.IBankAccountAdvancedMenu;
import io.github.lightman314.lightmanscurrency.common.bank.interfaces.IBankAccountMenu;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationSaveData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankTransferNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.DepositWithdrawNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullSupplier;

public class BankAccount {
    private final Runnable markDirty;
    private CoinValue coinStorage = CoinValue.EMPTY;
    private CoinValue notificationLevel = CoinValue.EMPTY;
    private Consumer<NonNullSupplier<Notification>> notificationSender;
    private final NotificationData logger = new NotificationData();
    private String ownerName = "Unknown";

    public CoinValue getCoinStorage() {
        return this.coinStorage;
    }

    public CoinValue getNotificationValue() {
        return this.notificationLevel;
    }

    public long getNotificationLevel() {
        return this.notificationLevel.getValueNumber();
    }

    public void setNotificationValue(CoinValue value) {
        this.notificationLevel = value;
        this.markDirty();
    }

    public void setNotificationConsumer(Consumer<NonNullSupplier<Notification>> notificationSender) {
        this.notificationSender = notificationSender;
    }

    public void pushLocalNotification(Notification notification) {
        this.logger.addNotification(notification);
        this.markDirty();
    }

    public void pushNotification(NonNullSupplier<Notification> notification) {
        this.pushLocalNotification((Notification)notification.get());
        if (this.notificationSender != null) {
            this.notificationSender.accept(notification);
        }
    }

    public static Consumer<NonNullSupplier<Notification>> generateNotificationAcceptor(UUID playerID) {
        return notification -> NotificationSaveData.PushNotification(playerID, (Notification)notification.get());
    }

    public List<Notification> getNotifications() {
        return this.logger.getNotifications();
    }

    public String getOwnersName() {
        return this.ownerName;
    }

    public void updateOwnersName(String ownerName) {
        this.ownerName = ownerName;
    }

    public MutableComponent getName() {
        return EasyText.translatable("lightmanscurrency.bankaccount", this.ownerName);
    }

    public void depositCoins(CoinValue depositAmount) {
        this.coinStorage = this.coinStorage.plusValue(depositAmount);
        this.markDirty();
    }

    public CoinValue withdrawCoins(CoinValue withdrawAmount) {
        long oldValue = this.coinStorage.getValueNumber();
        if (withdrawAmount.getValueNumber() > this.coinStorage.getValueNumber()) {
            withdrawAmount = this.coinStorage;
        }
        if (withdrawAmount.getValueNumber() <= 0L) {
            return CoinValue.EMPTY;
        }
        this.coinStorage = this.coinStorage.minusValue(withdrawAmount);
        this.markDirty();
        if (oldValue >= this.getNotificationLevel() && this.coinStorage.getValueNumber() < this.getNotificationLevel()) {
            this.pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new LowBalanceNotification(this.getName(), this.notificationLevel)));
        }
        return withdrawAmount;
    }

    public void LogInteraction(TaxEntry tax, CoinValue amount) {
        this.pushLocalNotification(new DepositWithdrawNotification.Trader(tax.getName(), this.getName(), true, amount));
        this.markDirty();
    }

    public void LogInteraction(Player player, CoinValue amount, boolean isDeposit) {
        this.pushLocalNotification(new DepositWithdrawNotification.Player(PlayerReference.of(player), this.getName(), isDeposit, amount));
        this.markDirty();
    }

    public void LogInteraction(TraderData trader, CoinValue amount, boolean isDeposit) {
        this.pushLocalNotification(new DepositWithdrawNotification.Trader(trader.getName(), this.getName(), isDeposit, amount));
        this.markDirty();
    }

    public void LogTransfer(Player player, CoinValue amount, MutableComponent otherAccount, boolean wasReceived) {
        this.pushLocalNotification(new BankTransferNotification(PlayerReference.of(player), amount, this.getName(), otherAccount, wasReceived));
        this.markDirty();
    }

    public static void DepositCoins(IBankAccountMenu menu, CoinValue amount) {
        if (menu == null) {
            return;
        }
        BankAccount.DepositCoins(menu.getPlayer(), menu.getCoinInput(), menu.getBankAccount(), amount);
    }

    public static void DepositCoins(Player player, Container coinInput, BankAccount account, CoinValue amount) {
        if (account == null) {
            return;
        }
        CoinValue actualAmount = MoneyUtil.getCoinValue(coinInput);
        if (amount.getValueNumber() > actualAmount.getValueNumber() || amount.getValueNumber() <= 0L) {
            amount = actualAmount;
        }
        MoneyUtil.ProcessPayment(coinInput, player, amount, true);
        account.depositCoins(amount);
        account.LogInteraction(player, amount, true);
    }

    public static boolean ServerGiveCoins(BankAccount account, CoinValue amount) {
        if (account == null || !amount.hasAny()) {
            return false;
        }
        account.depositCoins(amount);
        account.pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new DepositWithdrawNotification.Server(account.getName(), true, amount)));
        return true;
    }

    public static Pair<Boolean, CoinValue> ServerTakeCoins(BankAccount account, CoinValue amount) {
        if (account == null || !amount.hasAny()) {
            return Pair.of((Object)false, (Object)CoinValue.EMPTY);
        }
        CoinValue taken = account.withdrawCoins(amount);
        account.pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new DepositWithdrawNotification.Server(account.getName(), false, taken)));
        return Pair.of((Object)true, (Object)taken);
    }

    public static void WithdrawCoins(IBankAccountMenu menu, CoinValue amount) {
        if (menu == null) {
            return;
        }
        BankAccount.WithdrawCoins(menu.getPlayer(), menu.getCoinInput(), menu.getBankAccount(), amount);
    }

    public static void WithdrawCoins(Player player, Container coinOutput, BankAccount account, CoinValue amount) {
        if (account == null || amount.getValueNumber() <= 0L) {
            return;
        }
        CoinValue withdrawnAmount = account.withdrawCoins(amount);
        List<ItemStack> coins = MoneyUtil.getCoinsOfValue(withdrawnAmount);
        for (ItemStack coin : coins) {
            ItemStack remainder = InventoryUtil.TryPutItemStack(coinOutput, coin);
            if (remainder.m_41619_() || player.m_36356_(remainder)) continue;
            InventoryUtil.dumpContents(player.f_19853_, player.m_142538_(), remainder);
        }
        account.LogInteraction(player, withdrawnAmount, false);
    }

    public static MutableComponent TransferCoins(IBankAccountAdvancedMenu menu, CoinValue amount, BankReference destination) {
        return BankAccount.TransferCoins(menu.getPlayer(), menu.getBankAccount(), amount, destination == null ? null : destination.get());
    }

    public static MutableComponent TransferCoins(Player player, BankAccount fromAccount, CoinValue amount, BankAccount destinationAccount) {
        if (fromAccount == null) {
            return EasyText.translatable("gui.bank.transfer.error.null.from", new Object[0]);
        }
        if (destinationAccount == null) {
            return EasyText.translatable("gui.bank.transfer.error.null.to", new Object[0]);
        }
        if (amount.getValueNumber() <= 0L) {
            return EasyText.translatable("gui.bank.transfer.error.amount", amount.getString("nothing"));
        }
        if (fromAccount == destinationAccount) {
            return EasyText.translatable("gui.bank.transfer.error.same", new Object[0]);
        }
        CoinValue withdrawnAmount = fromAccount.withdrawCoins(amount);
        if (withdrawnAmount.getValueNumber() <= 0L) {
            return EasyText.translatable("gui.bank.transfer.error.nobalance", amount.getString());
        }
        destinationAccount.depositCoins(withdrawnAmount);
        fromAccount.LogTransfer(player, withdrawnAmount, destinationAccount.getName(), false);
        destinationAccount.LogTransfer(player, withdrawnAmount, fromAccount.getName(), true);
        return EasyText.translatable("gui.bank.transfer.success", withdrawnAmount.getString(), destinationAccount.getName());
    }

    public BankAccount() {
        this((Runnable)null);
    }

    public BankAccount(Runnable markDirty) {
        this.markDirty = markDirty;
    }

    public BankAccount(CompoundTag compound) {
        this(null, compound);
    }

    public BankAccount(Runnable markDirty, CompoundTag compound) {
        this.markDirty = markDirty;
        this.coinStorage = CoinValue.safeLoad(compound, "CoinStorage");
        this.logger.load(compound.m_128469_("AccountLogs"));
        this.ownerName = compound.m_128461_("OwnerName");
        this.notificationLevel = CoinValue.safeLoad(compound, "NotificationLevel");
    }

    public void markDirty() {
        if (this.markDirty != null) {
            this.markDirty.run();
        }
    }

    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("CoinStorage", (Tag)this.coinStorage.save());
        compound.m_128365_("AccountLogs", (Tag)this.logger.save());
        compound.m_128359_("OwnerName", this.ownerName);
        compound.m_128365_("NotificationLevel", (Tag)this.notificationLevel.save());
        return compound;
    }
}

