/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.bank.reference;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReferenceType;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.TeamBankReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class BankReference {
    private boolean isClient = false;
    protected final BankReferenceType type;

    public boolean isClient() {
        return this.isClient;
    }

    public BankReference flagAsClient() {
        return this.flagAsClient(true);
    }

    public BankReference flagAsClient(boolean isClient) {
        this.isClient = isClient;
        return this;
    }

    protected BankReference(BankReferenceType type) {
        this.type = type;
    }

    @Nullable
    public abstract BankAccount get();

    public abstract boolean allowedAccess(@Nonnull Player var1);

    public boolean canPersist(@Nonnull Player player) {
        return true;
    }

    public final CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        tag.m_128359_("Type", this.type.id.toString());
        return tag;
    }

    protected abstract void saveAdditional(CompoundTag var1);

    public final void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.type.id.toString());
        this.encodeAdditional(buffer);
    }

    protected abstract void encodeAdditional(FriendlyByteBuf var1);

    @Nullable
    public static BankReference load(CompoundTag tag) {
        if (tag.m_128441_("Type")) {
            BankReferenceType type = BankReferenceType.getType(new ResourceLocation(tag.m_128461_("Type")));
            if (type != null) {
                return type.load(tag);
            }
            LightmansCurrency.LogWarning("No Bank Reference Type '" + type + "' could be loaded.");
        } else {
            if (tag.m_128441_("PlayerID")) {
                return PlayerBankReference.of(tag.m_128342_("PlayerID"));
            }
            if (tag.m_128441_("TeamID")) {
                return TeamBankReference.of(tag.m_128454_("TeamID"));
            }
        }
        return null;
    }

    @Nullable
    public static BankReference decode(FriendlyByteBuf buffer) {
        BankReferenceType type = BankReferenceType.getType(new ResourceLocation(buffer.m_130277_()));
        if (type != null) {
            return type.decode(buffer);
        }
        LightmansCurrency.LogWarning("No Bank Reference Type '" + type + "' could be decoded.");
        return null;
    }
}

