/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.bank.reference.types;

import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReferenceType;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PlayerBankReference
extends BankReference {
    public static final BankReferenceType TYPE = new Type();
    public final UUID playerID;

    protected PlayerBankReference(@Nonnull UUID playerID) {
        super(TYPE);
        this.playerID = playerID;
    }

    public static BankReference of(@Nonnull UUID player) {
        return new PlayerBankReference(player);
    }

    @Nullable
    public static BankReference of(@Nullable PlayerReference player) {
        return player != null ? new PlayerBankReference(player.id) : null;
    }

    public static BankReference of(@Nonnull Player player) {
        return new PlayerBankReference(player.m_142081_()).flagAsClient(player.f_19853_.f_46443_);
    }

    @Override
    @Nullable
    public BankAccount get() {
        return BankSaveData.GetBankAccount(this.isClient(), this.playerID);
    }

    @Override
    public boolean allowedAccess(@Nonnull Player player) {
        return LCAdminMode.isAdminPlayer(player) || this.playerID.equals(player.m_142081_());
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        tag.m_128362_("PlayerID", this.playerID);
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.playerID);
    }

    @Override
    public boolean canPersist(@Nonnull Player player) {
        return this.playerID.equals(player.m_142081_());
    }

    private static final class Type
    extends BankReferenceType {
        Type() {
            super(new ResourceLocation("lightmanscurrency", "personal"));
        }

        @Override
        public BankReference load(CompoundTag tag) {
            return PlayerBankReference.of(tag.m_128342_("PlayerID"));
        }

        @Override
        public BankReference decode(FriendlyByteBuf buffer) {
            return PlayerBankReference.of(buffer.m_130259_());
        }
    }
}

