/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.interfaces.tickable.IClientTicker;
import io.github.lightman314.lightmanscurrency.common.blockentity.interfaces.tickable.IServerTicker;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.util.CoinContainer;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CoinChestBlockEntity
extends EasyBlockEntity
implements UpgradeType.IUpgradeable,
IClientTicker,
IServerTicker,
LidBlockEntity {
    private final ChestLidController chestLidController = new ChestLidController();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, @Nonnull BlockState state) {
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
        }

        protected void m_142289_(Level level, BlockPos pos, @Nonnull BlockState state) {
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
        }

        protected void m_142148_(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, int oldCount, int newCount) {
            level.m_7696_(CoinChestBlockEntity.this.f_58858_, (Block)ModBlocks.COIN_CHEST.get(), 1, newCount);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (!(abstractContainerMenu instanceof CoinChestMenu)) return false;
            CoinChestMenu ccm = (CoinChestMenu)abstractContainerMenu;
            if (ccm.be != CoinChestBlockEntity.this) return false;
            return true;
        }
    };
    public static final int STORAGE_ROWS = 3;
    public static final int STORAGE_SIZE = 27;
    public static final int UPGRADE_SIZE = 3;
    private final ItemHandler handler = new ItemHandler(this);
    private Component customName = null;
    private CoinContainer storage;
    private SimpleContainer upgrades;
    private List<CoinChestUpgradeData> unfilteredUpgradeDataCache = new ArrayList<CoinChestUpgradeData>();
    private List<CoinChestUpgradeData> upgradeDataCache = new ArrayList<CoinChestUpgradeData>();
    private boolean allowEvents = true;
    private final List<Player> relevantPlayers = new ArrayList<Player>();

    public int getOpenerCount() {
        return this.openersCounter.m_155450_();
    }

    public void setCustomName(Component name) {
        this.customName = name;
        this.markCustomNameDirty();
    }

    public Component getDisplayName() {
        return this.customName != null ? this.customName : EasyText.translatable("block.lightmanscurrency.coin_chest", new Object[0]);
    }

    public final CoinContainer getStorage() {
        return this.storage;
    }

    public final SimpleContainer getUpgrades() {
        return this.upgrades;
    }

    public final ImmutableList<CoinChestUpgradeData> getChestUpgrades() {
        if (this.unfilteredUpgradeDataCache.size() != 3) {
            this.refreshUpgradeCache();
        }
        return ImmutableList.copyOf(this.upgradeDataCache);
    }

    private void refreshUpgradeCache() {
        List<CoinChestUpgradeData> oldList = this.unfilteredUpgradeDataCache;
        this.unfilteredUpgradeDataCache = new ArrayList<CoinChestUpgradeData>();
        for (int i = 0; i < 3; ++i) {
            this.unfilteredUpgradeDataCache.add(CoinChestUpgradeData.forItem(this.upgrades.m_8020_(i), i, this::markUpgradesChanged));
            if (i >= oldList.size()) continue;
            this.unfilteredUpgradeDataCache.get(i).copyRelevantData(oldList.get(i));
        }
        this.upgradeDataCache = this.unfilteredUpgradeDataCache.stream().filter(CoinChestUpgradeData::notNull).toList();
    }

    @Nullable
    public final CoinChestUpgradeData getChestUpgradeForSlot(int slot) {
        ImmutableList<CoinChestUpgradeData> list = this.getChestUpgrades();
        if (slot >= 0 && slot < list.size()) {
            return (CoinChestUpgradeData)list.get(slot);
        }
        return null;
    }

    public final boolean hasChestUpgradeOfType(CoinChestUpgrade type) {
        return this.getChestUpgradeOfType(type) != null;
    }

    @Nullable
    public final CoinChestUpgradeData getChestUpgradeOfType(CoinChestUpgrade type) {
        for (CoinChestUpgradeData data : this.getChestUpgrades()) {
            if (data.upgrade != type) continue;
            return data;
        }
        return null;
    }

    public CoinChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.COIN_CHEST.get(), pos, state);
        this.storage = new CoinContainer(27);
        this.storage.m_19164_(i -> this.markStorageDirty());
        this.upgrades = new SimpleContainer(3);
        this.upgrades.m_19164_(i -> this.markUpgradesDirty());
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Name")) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        }
        if (compound.m_128441_("Storage")) {
            this.storage = new CoinContainer((Container)InventoryUtil.loadAllItems("Storage", compound, 27));
            this.storage.m_19164_(i -> this.markStorageDirty());
        }
        if (compound.m_128441_("Upgrades")) {
            this.upgrades = InventoryUtil.loadAllItems("Upgrades", compound, 3);
            this.upgrades.m_19164_(i -> this.markUpgradesDirty());
            this.refreshUpgradeCache();
        }
    }

    public static MenuProvider getMenuProvider(CoinChestBlockEntity be) {
        return new CoinChestMenuProvider(be);
    }

    protected void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        this.saveCustomName(compound);
        this.saveStorage(compound);
        this.saveUpgrades(compound);
    }

    protected CompoundTag saveCustomName(CompoundTag compound) {
        if (this.customName != null) {
            compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.customName));
        }
        return compound;
    }

    protected CompoundTag saveStorage(CompoundTag compound) {
        InventoryUtil.saveAllItems("Storage", compound, (Container)this.storage);
        return compound;
    }

    protected CompoundTag saveUpgrades(CompoundTag compound) {
        InventoryUtil.saveAllItems("Upgrades", compound, (Container)this.upgrades);
        return compound;
    }

    public final void markCustomNameDirty() {
        this.m_6596_();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveCustomName(new CompoundTag()));
        }
    }

    public final void markStorageDirty() {
        this.m_6596_();
        if (this.isServer() && this.allowEvents) {
            this.allowEvents = false;
            for (CoinChestUpgradeData data : this.getChestUpgrades()) {
                try {
                    data.upgrade.OnStorageChanged(this, data);
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error on CoinChestUpgrade Storage Change listener!", t);
                }
            }
            this.allowEvents = true;
            BlockEntityUtil.sendUpdatePacket(this, this.saveStorage(new CompoundTag()));
        }
    }

    public final void markUpgradesDirty() {
        this.refreshUpgradeCache();
        this.markUpgradesChanged();
    }

    private void markUpgradesChanged() {
        this.m_6596_();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveUpgrades(new CompoundTag()));
        }
    }

    public final void checkUpgradeEquipped(int slot) {
        if (this.isClient()) {
            return;
        }
        CoinChestUpgradeData data = this.getChestUpgradeForSlot(slot);
        if (data != null) {
            try {
                data.upgrade.OnEquip(this, data);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error during CoinChestUpgrade's Equip listener!", t);
            }
        }
        for (int i = 0; i < this.relevantPlayers.size(); ++i) {
            Player player = this.relevantPlayers.get(i);
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof CoinChestMenu) {
                CoinChestMenu menu = (CoinChestMenu)abstractContainerMenu;
                if (menu.be == this) {
                    menu.SendMessageToClient(LazyPacketData.builder().setBoolean("RefreshTabs", true));
                    continue;
                }
            }
            this.relevantPlayers.remove(i);
            --i;
        }
    }

    @Override
    public void clientTick() {
        this.chestLidController.m_155374_();
    }

    @Override
    public void serverTick() {
        for (CoinChestUpgradeData data : this.getChestUpgrades()) {
            data.tick(this);
        }
    }

    @Override
    public boolean allowUpgrade(UpgradeType type) {
        CoinChestUpgrade upgrade;
        return type instanceof CoinChestUpgrade && ((upgrade = (CoinChestUpgrade)type).allowsDuplicates() || !this.hasChestUpgradeOfType(upgrade));
    }

    public boolean allowAccess(Player player) {
        if (LCAdminMode.isAdminPlayer(player)) {
            return true;
        }
        for (CoinChestUpgradeData data : this.getChestUpgrades()) {
            if (!data.upgrade.BlockAccess(this, data, player)) continue;
            return false;
        }
        return true;
    }

    public void onValidBlockRemoval() {
        for (CoinChestUpgradeData data : this.getChestUpgrades()) {
            data.upgrade.OnValidBlockRemoval(this, data);
        }
    }

    public void onBlockRemoval() {
        for (CoinChestUpgradeData data : this.getChestUpgrades()) {
            data.upgrade.OnBlockRemoval(this, data);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.handler));
        }
        return super.getCapability(cap, side);
    }

    public float m_6683_(float partial) {
        return this.chestLidController.m_155375_(partial);
    }

    public boolean m_7531_(int event, int value) {
        if (event == 1) {
            this.chestLidController.m_155377_(value > 0);
            return true;
        }
        return super.m_7531_(event, value);
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
        if (!this.relevantPlayers.contains(player)) {
            this.relevantPlayers.add(player);
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
        this.relevantPlayers.remove(player);
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    private static class ItemHandler
    extends InvWrapper {
        private final CoinChestBlockEntity blockEntity;

        public ItemHandler(CoinChestBlockEntity blockEntity) {
            super((Container)blockEntity.storage);
            this.blockEntity = blockEntity;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return MoneyUtil.isCoin(stack);
        }

        public Container getInv() {
            return this.blockEntity.storage;
        }
    }

    private record CoinChestMenuProvider(CoinChestBlockEntity be) implements MenuProvider
    {
        @Nonnull
        public Component m_5446_() {
            return this.be.getDisplayName();
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new CoinChestMenu(id, inventory, this.be);
        }
    }
}

