/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.common.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.CoinJarItem;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CoinJarBlockEntity
extends EasyBlockEntity {
    public static final int COIN_LIMIT = 64;
    private int color = -1;
    List<ItemStack> storage = new ArrayList<ItemStack>();
    private final ItemViewer viewer = new ItemViewer(this);

    public int getColor() {
        return this.color >= 0 ? this.color : 0xFFFFFF;
    }

    public List<ItemStack> getStorage() {
        return this.storage;
    }

    public void clearStorage() {
        this.storage.clear();
    }

    public CoinJarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.COIN_JAR.get(), pos, state);
    }

    public boolean addCoin(ItemStack coin) {
        if (this.getCurrentCount() >= 64) {
            return false;
        }
        if (!MoneyUtil.isCoin(coin, false)) {
            return false;
        }
        boolean foundStack = false;
        for (int i = 0; i < this.storage.size() && !foundStack; ++i) {
            if (!InventoryUtil.ItemMatches(coin, this.storage.get(i)) || this.storage.get(i).m_41613_() >= this.storage.get(i).m_41741_()) continue;
            this.storage.get(i).m_41769_(1);
            foundStack = true;
        }
        if (!foundStack) {
            ItemStack newCoin = coin.m_41777_();
            newCoin.m_41764_(1);
            this.storage.add(newCoin);
        }
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeStorage(new CompoundTag()));
        }
        return true;
    }

    protected int getCurrentCount() {
        int count = 0;
        for (ItemStack stack : this.storage) {
            count += stack.m_41613_();
        }
        return count;
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        this.writeStorage(compound);
        if (this.color >= 0) {
            compound.m_128405_("Color", this.color);
        }
        super.m_183515_(compound);
    }

    protected CompoundTag writeStorage(CompoundTag compound) {
        ListTag storageList = new ListTag();
        for (ItemStack stack : this.storage) {
            storageList.add((Object)stack.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("Coins", (Tag)storageList);
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("Coins")) {
            this.storage = new ArrayList<ItemStack>();
            ListTag storageList = compound.m_128437_("Coins", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundTag thisItem = storageList.m_128728_(i);
                this.storage.add(ItemStack.m_41712_((CompoundTag)thisItem));
            }
        }
        if (compound.m_128441_("Color")) {
            this.color = compound.m_128451_("Color");
        }
        super.m_142466_(compound);
    }

    public void onLoad() {
        if (this.f_58857_.f_46443_) {
            BlockEntityUtil.requestUpdatePacket(this);
        }
    }

    public void writeItemTag(ItemStack item) {
        if (this.storage.size() > 0) {
            item.m_41784_().m_128365_("JarData", (Tag)this.writeStorage(new CompoundTag()));
        }
        this.writeSimpleItemTag(item);
    }

    public void writeSimpleItemTag(ItemStack item) {
        if (this.color >= 0) {
            CompoundTag compound = item.m_41784_();
            CompoundTag displayTag = new CompoundTag();
            displayTag.m_128405_("color", this.color);
            compound.m_128365_("display", (Tag)displayTag);
        }
    }

    public void readItemTag(ItemStack item) {
        if (item.m_41782_()) {
            Item item2;
            CompoundTag jarData;
            CompoundTag compound = item.m_41783_();
            if (compound.m_128425_("JarData", 10) && (jarData = compound.m_128469_("JarData")).m_128441_("Coins")) {
                this.storage = new ArrayList<ItemStack>();
                ListTag storageList = jarData.m_128437_("Coins", 10);
                for (int i = 0; i < storageList.size(); ++i) {
                    CompoundTag thisItem = storageList.m_128728_(i);
                    this.storage.add(ItemStack.m_41712_((CompoundTag)thisItem));
                }
            }
            if ((item2 = item.m_41720_()) instanceof CoinJarItem.Colored) {
                CoinJarItem.Colored coloredJar = (CoinJarItem.Colored)item2;
                this.color = coloredJar.m_41121_(item);
            }
            this.m_6596_();
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.viewer));
        }
        return super.getCapability(cap, side);
    }

    private record ItemViewer(CoinJarBlockEntity be) implements IItemHandler
    {
        public int getSlots() {
            return this.be.storage.size();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot >= 0 && slot < this.be.storage.size()) {
                return this.be.storage.get(slot).m_41777_();
            }
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack.m_41777_();
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    }
}

