/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.interfaces.tickable.IServerTicker;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeValidator;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class CoinMintBlockEntity
extends EasyBlockEntity
implements IServerTicker {
    SimpleContainer storage = new SimpleContainer(2);
    private CoinMintRecipe lastRelevantRecipe = null;
    private int mintTime = 0;
    private final MintItemCapability itemHandler = new MintItemCapability(this);
    private final LazyOptional<IItemHandler> inventoryHandlerLazyOptional = LazyOptional.of(() -> this.itemHandler);

    public SimpleContainer getStorage() {
        return this.storage;
    }

    public int getMintTime() {
        return this.mintTime;
    }

    public float getMintProgress() {
        return (float)this.mintTime / (float)this.getExpectedMintTime();
    }

    public int getExpectedMintTime() {
        if (this.lastRelevantRecipe != null) {
            return this.lastRelevantRecipe.getDuration();
        }
        return -1;
    }

    private List<CoinMintRecipe> getCoinMintRecipes() {
        if (this.f_58857_ != null) {
            return CoinMintBlockEntity.getCoinMintRecipes(this.f_58857_);
        }
        return Lists.newArrayList();
    }

    public static List<CoinMintRecipe> getCoinMintRecipes(Level level) {
        return RecipeValidator.getValidRecipes(level).getCoinMintRecipes();
    }

    public CoinMintBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.COIN_MINT.get(), pos, state);
    }

    protected CoinMintBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.storage.m_19164_(this::onInventoryChanged);
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        InventoryUtil.saveAllItems("Storage", compound, (Container)this.storage);
        compound.m_128405_("MintTime", this.mintTime);
        super.m_183515_(compound);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.storage = InventoryUtil.loadAllItems("Storage", compound, 2);
        this.storage.m_19164_(this::onInventoryChanged);
        if (compound.m_128441_("MintTime")) {
            this.mintTime = compound.m_128451_("MintTime");
        }
    }

    public void onLoad() {
        if (this.f_58857_.f_46443_) {
            BlockEntityUtil.requestUpdatePacket(this);
        }
        this.lastRelevantRecipe = this.getRelevantRecipe();
    }

    private void onInventoryChanged(Container inventory) {
        if (inventory != this.storage) {
            return;
        }
        this.m_6596_();
        CoinMintRecipe newRecipe = this.getRelevantRecipe();
        if (this.lastRelevantRecipe != newRecipe) {
            this.lastRelevantRecipe = newRecipe;
            this.mintTime = 0;
            this.markMintTimeDirty();
        }
    }

    @Override
    public void serverTick() {
        if (this.lastRelevantRecipe != null && this.storage.m_8020_(0).m_41613_() >= this.lastRelevantRecipe.ingredientCount && this.hasOutputSpace()) {
            ++this.mintTime;
            if (this.mintTime >= this.lastRelevantRecipe.getDuration()) {
                this.mintTime = 0;
                this.mintCoin();
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            this.markMintTimeDirty();
        } else if (this.mintTime > 0) {
            this.mintTime = 0;
            this.markMintTimeDirty();
        }
    }

    private void markMintTimeDirty() {
        this.m_6596_();
        CompoundTag updateTag = new CompoundTag();
        updateTag.m_128405_("MintTime", this.mintTime);
        BlockEntityUtil.sendUpdatePacket(this, updateTag);
    }

    public void dumpContents(Level world, BlockPos pos) {
        InventoryUtil.dumpContents(world, pos, (Container)this.storage);
    }

    public boolean validMintInput(ItemStack item) {
        SimpleContainer tempInv = new SimpleContainer(2);
        tempInv.m_6836_(0, item);
        for (CoinMintRecipe recipe : this.getCoinMintRecipes()) {
            if (!recipe.m_5818_((Container)tempInv, this.f_58857_)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOutputSpace() {
        if (this.lastRelevantRecipe == null) {
            return false;
        }
        ItemStack mintOutput = this.lastRelevantRecipe.m_8043_();
        ItemStack currentOutputSlot = this.getStorage().m_8020_(1);
        if (currentOutputSlot.m_41619_()) {
            return true;
        }
        if (!InventoryUtil.ItemMatches(currentOutputSlot, mintOutput)) {
            return false;
        }
        return currentOutputSlot.m_41741_() - currentOutputSlot.m_41613_() >= this.lastRelevantRecipe.m_8043_().m_41613_();
    }

    @Nullable
    public CoinMintRecipe getRelevantRecipe() {
        ItemStack mintInput = this.getStorage().m_8020_(0);
        if (mintInput.m_41619_()) {
            return null;
        }
        for (CoinMintRecipe recipe : this.getCoinMintRecipes()) {
            if (!recipe.m_5818_((Container)this.storage, this.f_58857_)) continue;
            return recipe;
        }
        return null;
    }

    public void mintCoin() {
        this.lastRelevantRecipe = this.getRelevantRecipe();
        if (this.lastRelevantRecipe == null) {
            return;
        }
        ItemStack mintOutput = this.lastRelevantRecipe.m_8043_();
        if (mintOutput.m_41619_()) {
            return;
        }
        if (!this.hasOutputSpace()) {
            return;
        }
        if (this.storage.m_8020_(0).m_41613_() < this.lastRelevantRecipe.ingredientCount) {
            return;
        }
        if (this.getStorage().m_8020_(1).m_41619_()) {
            this.getStorage().m_6836_(1, mintOutput);
        } else {
            this.getStorage().m_8020_(1).m_41769_(mintOutput.m_41613_());
        }
        this.getStorage().m_7407_(0, mintOutput.m_41613_());
        this.m_6596_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.inventoryHandlerLazyOptional);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHandlerLazyOptional.invalidate();
    }

    public static class MintItemCapability
    implements IItemHandler {
        final CoinMintBlockEntity mint;

        public MintItemCapability(CoinMintBlockEntity tileEntity) {
            this.mint = tileEntity;
        }

        public int getSlots() {
            return this.mint.getStorage().m_6643_();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.mint.getStorage().m_8020_(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot != 0) {
                return stack.m_41777_();
            }
            if (!this.mint.validMintInput(stack)) {
                return stack.m_41777_();
            }
            ItemStack currentStack = this.mint.getStorage().m_8020_(0);
            if (currentStack.m_41619_()) {
                if (stack.m_41613_() > stack.m_41741_()) {
                    stack = stack.m_41777_();
                    ItemStack placeStack = stack.m_41620_(stack.m_41741_());
                    if (!simulate) {
                        this.mint.getStorage().m_6836_(0, placeStack);
                    }
                    return stack;
                }
                if (!simulate) {
                    this.mint.getStorage().m_6836_(0, stack.m_41777_());
                }
                return ItemStack.f_41583_;
            }
            if (InventoryUtil.ItemMatches(currentStack, stack)) {
                int newAmount = MathUtil.clamp(currentStack.m_41613_() + stack.m_41613_(), 0, currentStack.m_41741_());
                if (!simulate) {
                    ItemStack newStack = currentStack.m_41777_();
                    newStack.m_41764_(newAmount);
                    this.mint.getStorage().m_6836_(0, newStack);
                }
                ItemStack leftoverStack = stack.m_41777_();
                leftoverStack.m_41764_(stack.m_41613_() + currentStack.m_41613_() - newAmount);
                return leftoverStack;
            }
            return stack.m_41777_();
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 1) {
                return ItemStack.f_41583_;
            }
            amount = MathUtil.clamp(amount, 0, 64);
            ItemStack currentStack = this.mint.getStorage().m_8020_(1).m_41777_();
            if (currentStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack outputStack = currentStack.m_41777_();
            if (outputStack.m_41613_() > amount) {
                outputStack.m_41764_(amount);
            }
            if (!simulate) {
                currentStack.m_41764_(currentStack.m_41613_() - outputStack.m_41613_());
                if (currentStack.m_41613_() <= 0) {
                    currentStack = ItemStack.f_41583_;
                }
                this.mint.getStorage().m_6836_(1, currentStack);
            }
            return outputStack;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot == 0 && this.mint.validMintInput(stack);
        }
    }
}

