/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.common.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.ItemInterfaceHandler;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class ItemTraderInterfaceBlockEntity
extends TraderInterfaceBlockEntity
implements TraderItemStorage.ITraderItemFilter {
    private final TraderItemStorage itemBuffer = new TraderItemStorage(this);
    ItemInterfaceHandler itemHandler = this.addHandler(new ItemInterfaceHandler(this, this::getItemBuffer));

    public TraderItemStorage getItemBuffer() {
        return this.itemBuffer;
    }

    public ItemInterfaceHandler getItemHandler() {
        return this.itemHandler;
    }

    public ItemTraderInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRADER_INTERFACE_ITEM.get(), pos, state);
    }

    @Override
    public TradeContext.Builder buildTradeContext(TradeContext.Builder baseContext) {
        return baseContext.withItemHandler(this.itemBuffer);
    }

    public boolean allowInput(ItemStack item) {
        block6: {
            block5: {
                ItemTradeData trade;
                block7: {
                    if (!this.getInteractionType().trades) break block5;
                    TradeData t = this.getReferencedTrade();
                    if (!(t instanceof ItemTradeData)) break block6;
                    trade = (ItemTradeData)t;
                    if (!trade.isBarter()) break block7;
                    for (int i = 0; i < 2; ++i) {
                        if (!InventoryUtil.ItemMatches(item, trade.getBarterItem(i))) continue;
                        return true;
                    }
                    break block6;
                }
                if (!trade.isPurchase()) break block6;
                for (int i = 0; i < 2; ++i) {
                    if (!InventoryUtil.ItemMatches(item, trade.getSellItem(i))) continue;
                    return true;
                }
                break block6;
            }
            TraderData trader = this.getTrader();
            if (trader instanceof ItemTraderData) {
                for (ItemTradeData trade : ((ItemTraderData)trader).getTradeData()) {
                    if (!trade.isSale() && !trade.isBarter()) continue;
                    for (int i = 0; i < 2; ++i) {
                        if (!InventoryUtil.ItemMatches(item, trade.getSellItem(i))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean allowOutput(ItemStack item) {
        return !this.allowInput(item);
    }

    @Override
    public boolean isItemRelevant(ItemStack item) {
        if (this.getInteractionType().trades) {
            TradeData t = this.getReferencedTrade();
            if (t instanceof ItemTradeData) {
                ItemTradeData trade = (ItemTradeData)t;
                return trade.allowItemInStorage(item);
            }
        } else {
            TraderData trader = this.getTrader();
            if (trader instanceof ItemTraderData) {
                ItemTraderData it = (ItemTraderData)trader;
                for (ItemTradeData trade : it.getTradeData()) {
                    if (!trade.allowItemInStorage(item)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgradeInventory().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgradeInventory().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            limit += UpgradeItem.getUpgradeData(stack).getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    @Override
    protected ItemTradeData deserializeTrade(CompoundTag compound) {
        return ItemTradeData.loadData(compound, false);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        this.saveItemBuffer(compound);
    }

    protected final CompoundTag saveItemBuffer(CompoundTag compound) {
        this.itemBuffer.save(compound, "Storage");
        return compound;
    }

    public void setItemBufferDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveItemBuffer(new CompoundTag()));
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Storage")) {
            this.itemBuffer.load(compound, "Storage");
        }
    }

    @Override
    public boolean validTraderType(TraderData trader) {
        return trader instanceof ItemTraderData;
    }

    protected final ItemTraderData getItemTrader() {
        TraderData trader = this.getTrader();
        if (trader instanceof ItemTraderData) {
            return (ItemTraderData)trader;
        }
        return null;
    }

    @Override
    protected void drainTick() {
        ItemTraderData trader = this.getItemTrader();
        if (trader != null && trader.hasPermission(this.owner.getPlayerForContext(), "interactionLink")) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = trader.getTrade(i);
                if (!trade.isValid()) continue;
                ArrayList<ItemStack> drainItems = new ArrayList<ItemStack>();
                if (trade.isPurchase()) {
                    drainItems.add(trade.getSellItem(0));
                    drainItems.add(trade.getSellItem(1));
                }
                if (trade.isBarter()) {
                    drainItems.add(trade.getBarterItem(0));
                    drainItems.add(trade.getBarterItem(1));
                }
                for (ItemStack drainItem : drainItems) {
                    int drainableAmount;
                    if (drainItem.m_41619_() || (drainableAmount = trader.getStorage().getItemCount(drainItem)) <= 0) continue;
                    ItemStack movingStack = drainItem.m_41777_();
                    movingStack.m_41764_(Math.min(movingStack.m_41741_(), drainableAmount));
                    ItemStack removed = trader.getStorage().removeItem(movingStack);
                    ItemStack leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemBuffer, (ItemStack)removed, (boolean)false);
                    if (!leftovers.m_41619_()) {
                        trader.getStorage().forceAddItem(leftovers);
                    }
                    this.setItemBufferDirty();
                    trader.markStorageDirty();
                }
            }
        }
    }

    @Override
    protected void restockTick() {
        ItemTraderData trader = this.getItemTrader();
        if (trader != null && trader.hasPermission(this.owner.getPlayerForContext(), "interactionLink")) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = trader.getTrade(i);
                if (!trade.isValid() || !trade.isBarter() && !trade.isSale()) continue;
                for (int s = 0; s < 2; ++s) {
                    int stockableAmount;
                    ItemStack stockItem = trade.getSellItem(s);
                    if (stockItem.m_41619_() || (stockableAmount = this.itemBuffer.getItemCount(stockItem)) <= 0) continue;
                    ItemStack movingStack = stockItem.m_41777_();
                    movingStack.m_41764_(Math.min(movingStack.m_41741_(), stockableAmount));
                    ItemStack removedItem = this.itemBuffer.removeItem(movingStack);
                    if (removedItem.m_41613_() == movingStack.m_41613_()) {
                        trader.getStorage().tryAddItem(movingStack);
                        if (!movingStack.m_41619_()) {
                            this.itemBuffer.forceAddItem(movingStack);
                        }
                    } else {
                        this.itemBuffer.forceAddItem(removedItem);
                    }
                    this.setItemBufferDirty();
                    trader.markStorageDirty();
                }
            }
        }
    }

    @Override
    protected void tradeTick() {
        ItemTradeData trade;
        TradeData t = this.getTrueTrade();
        if (t instanceof ItemTradeData && (trade = (ItemTradeData)t) != null && trade.isValid()) {
            if (trade.isSale()) {
                if (this.itemBuffer.canFitItems(trade.getSellItem(0), trade.getSellItem(1))) {
                    this.interactWithTrader();
                    this.setItemBufferDirty();
                }
            } else if (trade.isPurchase()) {
                if (this.itemBuffer.hasItems(trade.getSellItem(0), trade.getSellItem(1))) {
                    this.interactWithTrader();
                    this.setItemBufferDirty();
                }
            } else if (trade.isBarter() && this.itemBuffer.hasItems(trade.getBarterItem(0), trade.getBarterItem(1)) && this.itemBuffer.canFitItems(trade.getSellItem(0), trade.getSellItem(1))) {
                this.interactWithTrader();
                this.setItemBufferDirty();
            }
        }
    }

    @Override
    protected void hopperTick() {
        AtomicBoolean markBufferDirty = new AtomicBoolean(false);
        for (Direction relativeSide : Direction.values()) {
            BlockPos queryPos;
            BlockEntity be;
            if (!this.itemHandler.getInputSides().get(relativeSide) && !this.itemHandler.getOutputSides().get(relativeSide)) continue;
            Direction actualSide = relativeSide;
            Block block = this.m_58900_().m_60734_();
            if (block instanceof IRotatableBlock) {
                IRotatableBlock b = (IRotatableBlock)block;
                actualSide = IRotatableBlock.getActualSide(b.getFacing(this.m_58900_()), relativeSide);
            }
            if ((be = this.f_58857_.m_7702_(queryPos = this.f_58858_.m_142300_(actualSide))) == null) continue;
            be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, actualSide.m_122424_()).ifPresent(itemHandler -> {
                if (this.itemHandler.getInputSides().get(relativeSide)) {
                    boolean query = true;
                    for (int i = 0; query && i < itemHandler.getSlots(); ++i) {
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        int fittableAmount = this.itemBuffer.getFittableAmount(stack);
                        if (fittableAmount <= 0) continue;
                        query = false;
                        ItemStack result = itemHandler.extractItem(i, fittableAmount, false);
                        this.itemBuffer.forceAddItem(result);
                        markBufferDirty.set(true);
                    }
                }
                if (this.itemHandler.getOutputSides().get(relativeSide)) {
                    List<ItemStack> buffer = this.itemBuffer.getContents();
                    boolean query = true;
                    for (int i = 0; query && i < buffer.size(); ++i) {
                        ItemStack stack = buffer.get(i).m_41777_();
                        if (!this.allowOutput(stack)) continue;
                        for (int slot = 0; query && slot < itemHandler.getSlots(); ++slot) {
                            ItemStack result = itemHandler.insertItem(slot, stack.m_41777_(), false);
                            int placed = stack.m_41613_() - result.m_41613_();
                            if (placed <= 0) continue;
                            query = false;
                            stack.m_41764_(placed);
                            this.itemBuffer.removeItem(stack);
                            markBufferDirty.set(true);
                        }
                    }
                }
            });
        }
        if (markBufferDirty.get()) {
            this.setItemBufferDirty();
        }
    }

    @Override
    public void initMenuTabs(TraderInterfaceMenu menu) {
        menu.setTab(1, new ItemStorageTab(menu));
    }

    @Override
    public boolean allowAdditionalUpgrade(UpgradeType type) {
        return type == UpgradeType.ITEM_CAPACITY;
    }

    @Override
    public void getAdditionalContents(List<ItemStack> contents) {
        contents.addAll(this.itemBuffer.getSplitContents());
    }

    @Override
    public MutableComponent getName() {
        return new TranslatableComponent("block.lightmanscurrency.item_trader_interface");
    }
}

