/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.TeamBankReference;
import io.github.lightman314.lightmanscurrency.common.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.interfaces.tickable.IServerTicker;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.tradeinterface.templates.TraderInterfaceBlock;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.IDumpable;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.ownership.OwnerData;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.common.traderinterface.NetworkTradeReference;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.SpeedUpgrade;
import io.github.lightman314.lightmanscurrency.network.message.interfacebe.CPacketInterfaceHandlerMessage;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public abstract class TraderInterfaceBlockEntity
extends EasyBlockEntity
implements UpgradeType.IUpgradeable,
IDumpable,
IServerTicker {
    public static final int INTERACTION_DELAY = 20;
    private boolean allowRemoval = false;
    public final OwnerData owner = new OwnerData(this, o -> BlockEntityUtil.sendUpdatePacket(this, this.saveOwner(this.saveMode(new CompoundTag()))));
    List<SidedHandler<?>> handlers = new ArrayList();
    private ActiveMode mode = ActiveMode.DISABLED;
    private boolean onlineMode = false;
    private InteractionType interaction = InteractionType.TRADE;
    NetworkTradeReference reference = new NetworkTradeReference(this::isClient, this::deserializeTrade);
    private SimpleContainer upgradeSlots = new SimpleContainer(5);
    private TradeContext.TradeResult lastResult = TradeContext.TradeResult.SUCCESS;
    private int waitTimer = 20;

    public boolean allowRemoval() {
        return this.allowRemoval;
    }

    public void flagAsRemovable() {
        this.allowRemoval = true;
    }

    public void initOwner(Entity owner) {
        if (!this.owner.hasOwner()) {
            this.owner.SetOwner(PlayerReference.of(owner));
        }
    }

    public void setOwner(String name) {
        PlayerReference newOwner = PlayerReference.of(this.isClient(), name);
        if (newOwner != null) {
            this.owner.SetOwner(newOwner);
            this.mode = ActiveMode.DISABLED;
            this.m_6596_();
            if (!this.isClient()) {
                BlockEntityUtil.sendUpdatePacket(this, this.saveOwner(this.saveMode(new CompoundTag())));
            }
        }
    }

    public void setTeam(long teamID) {
        Team team = TeamSaveData.GetTeam(this.isClient(), teamID);
        if (team != null) {
            this.owner.SetOwner(team);
        }
    }

    public PlayerReference getReferencedPlayer() {
        return this.owner.getPlayerForContext();
    }

    public String getOwnerName() {
        return this.owner.getOwnerName(this.isClient());
    }

    public BankAccount getBankAccount() {
        BankReference reference = this.getAccountReference();
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    public BankReference getAccountReference() {
        if (this.owner.hasTeam()) {
            return TeamBankReference.of(this.owner.getTeam()).flagAsClient(this.isClient());
        }
        if (this.owner.hasPlayer()) {
            return PlayerBankReference.of(this.owner.getPlayer()).flagAsClient(this.isClient());
        }
        return null;
    }

    public ActiveMode getMode() {
        return this.mode;
    }

    public void setMode(ActiveMode mode) {
        this.mode = mode;
        this.setModeDirty();
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public void setOnlineMode(boolean onlineMode) {
        this.onlineMode = onlineMode;
        this.setOnlineModeDirty();
    }

    public InteractionType getInteractionType() {
        return this.interaction;
    }

    public void setInteractionType(InteractionType type) {
        if (this.getBlacklistedInteractions().contains((Object)type)) {
            LightmansCurrency.LogInfo("Attempted to set interaction type to " + type.name() + ", but that type is blacklisted for this interface type (" + this.getClass().getName() + ").");
            return;
        }
        this.interaction = type;
        this.setInteractionDirty();
    }

    public List<InteractionType> getBlacklistedInteractions() {
        return new ArrayList<InteractionType>();
    }

    public boolean hasTrader() {
        return this.getTrader() != null;
    }

    public TraderData getTrader() {
        TraderData trader = this.reference.getTrader();
        if (this.interaction.requiresPermissions && !this.hasTraderPermissions(trader)) {
            return null;
        }
        return trader;
    }

    public int getTradeIndex() {
        return this.reference.getTradeIndex();
    }

    public TradeData getReferencedTrade() {
        return this.reference.getLocalTrade();
    }

    public TradeData getTrueTrade() {
        return this.reference.getTrueTrade();
    }

    public Container getUpgradeInventory() {
        return this.upgradeSlots;
    }

    public void setUpgradeSlotsDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveUpgradeSlots(new CompoundTag()));
        }
    }

    public void setTrader(long traderID) {
        if (this.reference.getTraderID() == traderID) {
            return;
        }
        this.reference.setTrader(traderID);
        this.reference.setTrade(-1);
        this.setTradeReferenceDirty();
    }

    public void setTradeIndex(int tradeIndex) {
        this.reference.setTrade(tradeIndex);
        this.setTradeReferenceDirty();
    }

    public void acceptTradeChanges() {
        this.reference.refreshTrade();
        this.setTradeReferenceDirty();
    }

    public TradeContext.TradeResult mostRecentTradeResult() {
        return this.lastResult;
    }

    protected abstract TradeData deserializeTrade(CompoundTag var1);

    public boolean canAccess(Player player) {
        return this.owner.isMember(player);
    }

    public boolean isOwner(Player player) {
        return this.owner.isAdmin(player);
    }

    protected TraderInterfaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setModeDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveMode(new CompoundTag()));
        }
    }

    public void setOnlineModeDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveOnlineMode(new CompoundTag()));
        }
    }

    public void setLastResultDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveLastResult(new CompoundTag()));
        }
    }

    protected abstract TradeContext.Builder buildTradeContext(TradeContext.Builder var1);

    public TradeContext getTradeContext() {
        if (this.interaction.trades) {
            return this.buildTradeContext(TradeContext.create(this.getTrader(), this.getReferencedPlayer()).withBankAccount(this.getAccountReference())).build();
        }
        return TradeContext.createStorageMode(this.getTrader());
    }

    protected final <H extends SidedHandler<?>> H addHandler(@Nonnull H handler) {
        handler.setParent(this);
        this.handlers.add(handler);
        return handler;
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        this.saveOwner(compound);
        this.saveMode(compound);
        this.saveOnlineMode(compound);
        this.saveInteraction(compound);
        this.saveLastResult(compound);
        this.saveReference(compound);
        this.saveUpgradeSlots(compound);
        for (SidedHandler<?> handler : this.handlers) {
            this.saveHandler(compound, handler);
        }
    }

    protected final CompoundTag saveOwner(CompoundTag compound) {
        if (this.owner != null) {
            compound.m_128365_("Owner", (Tag)this.owner.save());
        }
        return compound;
    }

    protected final CompoundTag saveMode(CompoundTag compound) {
        compound.m_128359_("Mode", this.mode.name());
        return compound;
    }

    protected final CompoundTag saveOnlineMode(CompoundTag compound) {
        compound.m_128379_("OnlineMode", this.onlineMode);
        return compound;
    }

    protected final CompoundTag saveInteraction(CompoundTag compound) {
        compound.m_128359_("InteractionType", this.interaction.name());
        return compound;
    }

    protected final CompoundTag saveLastResult(CompoundTag compound) {
        compound.m_128359_("LastResult", this.lastResult.name());
        return compound;
    }

    protected final CompoundTag saveReference(CompoundTag compound) {
        compound.m_128365_("Trade", (Tag)this.reference.save());
        return compound;
    }

    protected final CompoundTag saveUpgradeSlots(CompoundTag compound) {
        InventoryUtil.saveAllItems("Upgrades", compound, (Container)this.upgradeSlots);
        return compound;
    }

    protected final CompoundTag saveHandler(CompoundTag compound, SidedHandler<?> handler) {
        compound.m_128365_(handler.getTag(), (Tag)handler.save());
        return compound;
    }

    public void setHandlerDirty(SidedHandler<?> handler) {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveHandler(new CompoundTag(), handler));
        }
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("Owner", 10)) {
            CompoundTag ownerTag = compound.m_128469_("Owner");
            if (ownerTag.m_128441_("id")) {
                this.owner.SetOwner(PlayerReference.load(ownerTag));
            } else {
                this.owner.load(ownerTag);
            }
        }
        if (compound.m_128441_("Mode")) {
            this.mode = (ActiveMode)EnumUtil.enumFromString((String)compound.m_128461_("Mode"), (Enum[])ActiveMode.values(), (Enum)ActiveMode.DISABLED);
        }
        if (compound.m_128441_("OnlineMode")) {
            this.onlineMode = compound.m_128471_("OnlineMode");
        }
        if (compound.m_128425_("InteractionType", 8)) {
            this.interaction = (InteractionType)EnumUtil.enumFromString((String)compound.m_128461_("InteractionType"), (Enum[])InteractionType.values(), (Enum)InteractionType.TRADE);
        }
        if (compound.m_128425_("Trade", 10)) {
            this.reference.load(compound.m_128469_("Trade"));
        }
        if (compound.m_128441_("Upgrades")) {
            this.upgradeSlots = InventoryUtil.loadAllItems("Upgrades", compound, 5);
        }
        for (SidedHandler<?> handler : this.handlers) {
            if (!compound.m_128425_(handler.getTag(), 10)) continue;
            handler.load(compound.m_128469_(handler.getTag()));
        }
    }

    public void setInteractionDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveInteraction(new CompoundTag()));
        }
    }

    @NotNull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> cap, @Nullable Direction side) {
        Direction relativeSide = this.getRelativeSide(side);
        for (SidedHandler<?> sidedHandler : this.handlers) {
            Object handler = sidedHandler.getHandler(relativeSide);
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && handler instanceof IItemHandler) {
                return LazyOptional.of(() -> (IItemHandler)handler).cast();
            }
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && handler instanceof IFluidHandler) {
                return LazyOptional.of(() -> (IFluidHandler)handler).cast();
            }
            if (cap != CapabilityEnergy.ENERGY || !(handler instanceof IEnergyStorage)) continue;
            return LazyOptional.of(() -> (IEnergyStorage)handler).cast();
        }
        return super.getCapability(cap, side);
    }

    protected final Direction getRelativeSide(Direction side) {
        Direction relativeSide = side;
        if (relativeSide != null & this.m_58900_().m_60734_() instanceof IRotatableBlock) {
            relativeSide = IRotatableBlock.getRelativeSide(((IRotatableBlock)this.m_58900_().m_60734_()).getFacing(this.m_58900_()), side);
        }
        return relativeSide;
    }

    public void sendHandlerMessage(ResourceLocation type, CompoundTag message) {
        if (this.isClient()) {
            new CPacketInterfaceHandlerMessage(this.f_58858_, type, message).send();
        }
    }

    public void receiveHandlerMessage(ResourceLocation type, Player player, CompoundTag message) {
        if (!this.canAccess(player)) {
            return;
        }
        for (SidedHandler<?> handler : this.handlers) {
            if (!handler.getType().equals((Object)type)) continue;
            handler.receiveMessage(message);
        }
    }

    public void setTradeReferenceDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveReference(new CompoundTag()));
        }
    }

    public TradeContext.TradeResult interactWithTrader() {
        TradeContext tradeContext = this.getTradeContext();
        TraderData trader = this.getTrader();
        this.lastResult = trader != null ? trader.TryExecuteTrade(tradeContext, this.reference.getTradeIndex()) : TradeContext.TradeResult.FAIL_NULL;
        this.setLastResultDirty();
        return this.lastResult;
    }

    public boolean isActive() {
        return this.mode.isActive(this) && this.onlineCheck();
    }

    public boolean onlineCheck() {
        if (this.isClient()) {
            return false;
        }
        if (!this.onlineMode) {
            return true;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return false;
        }
        if (this.owner.hasTeam()) {
            Team team = this.owner.getTeam();
            for (PlayerReference member : team.getAllMembers()) {
                if (member == null || server.m_6846_().m_11259_(member.id) == null) continue;
                return true;
            }
        } else if (this.owner.hasPlayer()) {
            return server.m_6846_().m_11259_(this.owner.getPlayer().id) != null;
        }
        return false;
    }

    public final boolean hasTraderPermissions(TraderData trader) {
        if (trader == null) {
            return false;
        }
        Team team = this.owner.getTeam();
        if (team != null) {
            return trader.getOwner().getTeam() == team;
        }
        return trader.hasPermission(this.owner.getPlayer(), "interactionLink");
    }

    @Override
    public void serverTick() {
        if (this.isActive()) {
            --this.waitTimer;
            if (this.waitTimer <= 0) {
                this.waitTimer = this.getInteractionDelay();
                if (this.interaction.requiresPermissions) {
                    if (!this.validTrader() || !this.hasTraderPermissions(this.getTrader())) {
                        return;
                    }
                    if (this.interaction.drains) {
                        this.drainTick();
                    }
                    if (this.interaction.restocks) {
                        this.restockTick();
                    }
                } else if (this.interaction.trades) {
                    if (!this.validTrade()) {
                        return;
                    }
                    this.tradeTick();
                }
                if (this.hasHopperUpgrade()) {
                    this.hopperTick();
                }
            }
        }
    }

    public boolean validTrader() {
        TraderData trader = this.getTrader();
        return trader != null && this.validTraderType(trader);
    }

    public boolean validTrade() {
        TradeData expectedTrade = this.getReferencedTrade();
        TradeData trueTrade = this.getTrueTrade();
        if (expectedTrade == null || trueTrade == null) {
            return false;
        }
        return expectedTrade.AcceptableDifferences(expectedTrade.compare(trueTrade));
    }

    public abstract boolean validTraderType(TraderData var1);

    protected abstract void drainTick();

    protected abstract void restockTick();

    protected abstract void tradeTick();

    protected abstract void hopperTick();

    public void openMenu(Player player) {
        if (this.canAccess(player)) {
            MenuProvider provider = this.getMenuProvider();
            if (provider == null) {
                return;
            }
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)this.f_58858_);
        }
    }

    protected MenuProvider getMenuProvider() {
        return new InterfaceMenuProvider(this);
    }

    protected int getInteractionDelay() {
        int delay = 20;
        for (int i = 0; i < this.upgradeSlots.m_6643_() && delay > 1; ++i) {
            UpgradeItem upgrade;
            ItemStack stack = this.upgradeSlots.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !((upgrade = (UpgradeItem)item).getUpgradeType() instanceof SpeedUpgrade)) continue;
            delay -= UpgradeItem.getUpgradeData(stack).getIntValue(SpeedUpgrade.DELAY_AMOUNT);
        }
        return delay;
    }

    public abstract void initMenuTabs(TraderInterfaceMenu var1);

    @Override
    public boolean allowUpgrade(UpgradeType type) {
        return type == UpgradeType.SPEED || type == UpgradeType.HOPPER && this.allowHopperUpgrade() && !this.hasHopperUpgrade() || this.allowAdditionalUpgrade(type);
    }

    protected boolean allowHopperUpgrade() {
        return true;
    }

    protected boolean allowAdditionalUpgrade(UpgradeType type) {
        return false;
    }

    protected final boolean hasHopperUpgrade() {
        return UpgradeType.hasUpgrade(UpgradeType.HOPPER, (Container)this.upgradeSlots);
    }

    @Override
    public final List<ItemStack> getContents(Level level, BlockPos pos, BlockState state, boolean dropBlock) {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        if (dropBlock) {
            if (state.m_60734_() instanceof TraderInterfaceBlock) {
                contents.add(((TraderInterfaceBlock)state.m_60734_()).getDropBlockItem(state, this));
            } else {
                contents.add(new ItemStack((ItemLike)state.m_60734_()));
            }
        }
        for (int i = 0; i < this.upgradeSlots.m_6643_(); ++i) {
            if (this.upgradeSlots.m_8020_(i).m_41619_()) continue;
            contents.add(this.upgradeSlots.m_8020_(i));
        }
        this.getAdditionalContents(contents);
        return contents;
    }

    protected abstract void getAdditionalContents(List<ItemStack> var1);

    @Override
    public OwnerData getOwner() {
        return this.owner;
    }

    public static enum ActiveMode {
        DISABLED(0, be -> false),
        REDSTONE_OFF(1, be -> {
            if (((TraderInterfaceBlockEntity)be).f_58857_ != null) {
                return !((TraderInterfaceBlockEntity)be).f_58857_.m_46753_(be.m_58899_());
            }
            return false;
        }),
        REDSTONE_ONLY(2, be -> {
            if (((TraderInterfaceBlockEntity)be).f_58857_ != null) {
                return ((TraderInterfaceBlockEntity)be).f_58857_.m_46753_(be.m_58899_());
            }
            return false;
        }),
        ALWAYS_ON(3, be -> true);

        public final int index;
        private final Function<TraderInterfaceBlockEntity, Boolean> active;

        public final Component getDisplayText() {
            return EasyText.translatable("gui.lightmanscurrency.interface.mode." + this.name().toLowerCase(), new Object[0]);
        }

        public final ActiveMode getNext() {
            return ActiveMode.fromIndex(this.index + 1);
        }

        public boolean isActive(TraderInterfaceBlockEntity blockEntity) {
            return this.active.apply(blockEntity);
        }

        private ActiveMode(int index, Function<TraderInterfaceBlockEntity, Boolean> active) {
            this.index = index;
            this.active = active;
        }

        public static ActiveMode fromIndex(int index) {
            for (ActiveMode mode : ActiveMode.values()) {
                if (mode.index != index) continue;
                return mode;
            }
            return DISABLED;
        }
    }

    public static enum InteractionType {
        RESTOCK_AND_DRAIN(true, true, true, false, 3),
        RESTOCK(true, true, false, false, 1),
        DRAIN(true, false, true, false, 2),
        TRADE(false, false, false, true, 0);

        public final boolean requiresPermissions;
        public final boolean restocks;
        public final boolean drains;
        public final boolean trades;
        public final int index;

        public final Component getDisplayText() {
            return EasyText.translatable("gui.lightmanscurrency.interface.type." + this.name().toLowerCase(), new Object[0]);
        }

        private InteractionType(boolean requiresPermissions, boolean restocks, boolean drains, boolean trades, int index) {
            this.requiresPermissions = requiresPermissions;
            this.restocks = restocks;
            this.drains = drains;
            this.trades = trades;
            this.index = index;
        }

        public static InteractionType fromIndex(int index) {
            for (InteractionType type : InteractionType.values()) {
                if (type.index != index) continue;
                return type;
            }
            return TRADE;
        }

        public static int size() {
            return 4;
        }
    }

    public static class InterfaceMenuProvider
    implements EasyMenuProvider {
        private final TraderInterfaceBlockEntity blockEntity;

        public InterfaceMenuProvider(TraderInterfaceBlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        public AbstractContainerMenu m_7208_(int windowID, @NotNull Inventory inventory, @NotNull Player player) {
            return new TraderInterfaceMenu(windowID, inventory, this.blockEntity);
        }
    }
}

