/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.handler;

import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class TraderItemHandler {
    private final ItemTraderData trader;
    private final Map<Direction, IItemHandler> handlers = new HashMap<Direction, IItemHandler>();

    public TraderItemHandler(ItemTraderData trader) {
        this.trader = trader;
    }

    public IItemHandler getHandler(Direction side) {
        if (!this.handlers.containsKey(side)) {
            this.handlers.put(side, new TraderHandler(this.trader, side));
        }
        return this.handlers.get(side);
    }

    private static class TraderHandler
    implements IItemHandler {
        private final ItemTraderData trader;
        private final Direction side;

        protected TraderHandler(ItemTraderData trader, Direction side) {
            this.trader = trader;
            this.side = side;
        }

        protected final TraderItemStorage getStorage() {
            return this.trader.getStorage();
        }

        protected final boolean allowsInputs() {
            return this.trader.allowInputSide(this.side);
        }

        protected final boolean allowsOutputs() {
            return this.trader.allowOutputSide(this.side);
        }

        public int getSlots() {
            return this.getStorage().getContents().size() + 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot >= 0 && slot < this.getStorage().getContents().size()) {
                return this.getStorage().getContents().get(slot);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.getStorage().getMaxAmount();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.allowsInputs() && this.getStorage().allowItem(stack);
        }

        public boolean allowExtraction(ItemStack stack) {
            for (ItemTradeData trade : this.trader.getTradeData()) {
                if (!trade.isSale() && !trade.isBarter()) continue;
                for (int i = 0; i < 2; ++i) {
                    if (!trade.getItemRequirement(i).test(stack)) continue;
                    return false;
                }
            }
            return true;
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack copyStack = stack.m_41777_();
            if (this.allowsInputs() && this.getStorage().allowItem(stack)) {
                if (simulate) {
                    int inputAmount = Math.min(this.getStorage().getFittableAmount(copyStack), copyStack.m_41613_());
                    copyStack.m_41774_(inputAmount);
                } else {
                    this.getStorage().tryAddItem(copyStack);
                    this.trader.markStorageDirty();
                }
                return copyStack;
            }
            return copyStack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.allowsOutputs()) {
                ItemStack stackInSlot = this.getStackInSlot(slot).m_41777_();
                if (stackInSlot.m_41619_() || !this.allowExtraction(stackInSlot)) {
                    return ItemStack.f_41583_;
                }
                int amountToRemove = Math.min(amount, Math.min(stackInSlot.m_41613_(), stackInSlot.m_41741_()));
                if (amountToRemove > 0) {
                    ItemStack result = stackInSlot.m_41777_();
                    result.m_41764_(amountToRemove);
                    if (!simulate) {
                        stackInSlot.m_41764_(amountToRemove);
                        result = this.getStorage().removeItem(stackInSlot);
                    }
                    this.trader.markStorageDirty();
                    return result;
                }
                return ItemStack.f_41583_;
            }
            return ItemStack.f_41583_;
        }
    }
}

