/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import com.google.common.collect.Lists;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.ItemPositionData;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ItemTraderBlockEntity
extends TraderBlockEntity<ItemTraderData> {
    protected int tradeCount;
    protected boolean networkTrader;

    public ItemTraderBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.ITEM_TRADER.get(), pos, state, 1, false);
    }

    public ItemTraderBlockEntity(BlockPos pos, BlockState state, int tradeCount) {
        this((BlockEntityType)ModBlockEntities.ITEM_TRADER.get(), pos, state, tradeCount, false);
    }

    public ItemTraderBlockEntity(BlockPos pos, BlockState state, int tradeCount, boolean networkTrader) {
        this((BlockEntityType)ModBlockEntities.ITEM_TRADER.get(), pos, state, tradeCount, networkTrader);
    }

    protected ItemTraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 1, false);
    }

    protected ItemTraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int tradeCount) {
        this(type, pos, state, tradeCount, false);
    }

    protected ItemTraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int tradeCount, boolean networkTrader) {
        super(type, pos, state);
        this.tradeCount = tradeCount;
        this.networkTrader = networkTrader;
    }

    @Override
    @Nonnull
    public ItemTraderData buildNewTrader() {
        ItemTraderData trader = new ItemTraderData(this.tradeCount, this.f_58857_, this.f_58858_);
        if (this.networkTrader) {
            trader.setAlwaysShowOnTerminal();
        }
        return trader;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public ItemPositionData GetRenderData() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.getItemPositionData();
        }
        return ItemPositionData.EMPTY;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(since="2.1.2.4")
    public List<Vector3f> GetStackRenderPos(int tradeSlot, boolean isDoubleTrade) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.GetStackRenderPos(tradeSlot, this.m_58900_(), isDoubleTrade);
        }
        return Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f)});
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(since="2.1.2.4")
    public List<Quaternion> GetStackRenderRot(int tradeSlot, float partialTicks) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            List<Quaternion> rotation = traderBlock.GetStackRenderRot(tradeSlot, this.m_58900_());
            if (rotation == null) {
                rotation = new ArrayList<Quaternion>();
                rotation.add(ItemTraderBlockEntityRenderer.getRotation(partialTicks));
            }
            return rotation;
        }
        ArrayList<Quaternion> rotation = new ArrayList<Quaternion>();
        rotation.add(MathUtil.fromAxisAngleDegree(MathUtil.getYP(), 0.0f));
        return rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(since="2.1.2.4")
    public float GetStackRenderScale(int tradeSlot) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.GetStackRenderScale(tradeSlot, this.m_58900_());
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(since="2.1.2.4")
    public int maxRenderIndex() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.maxRenderIndex();
        }
        return 0;
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("TradeCount", this.tradeCount);
        compound.m_128379_("NetworkTrader", this.networkTrader);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.tradeCount = compound.m_128451_("TradeCount");
        this.networkTrader = compound.m_128471_("NetworkTrader");
    }
}

