/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.interfaces.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.interfaces.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CoinChestBlock
extends RotatableBlock
implements IEasyEntityBlock,
IOwnableBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public CoinChestBlock(BlockBehaviour.Properties properties) {
        super(properties, SHAPE);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity player, @Nonnull ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinChestBlockEntity) {
            CoinChestBlockEntity be = (CoinChestBlockEntity)blockEntity;
            if (stack.m_41788_()) {
                be.setCustomName(stack.m_41786_());
            }
        }
        super.m_6402_(level, pos, state, player, stack);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinChestBlockEntity) {
            CoinChestBlockEntity be = (CoinChestBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                if (be.allowAccess(player)) {
                    NetworkHooks.openGui((ServerPlayer)sp, (MenuProvider)CoinChestBlockEntity.getMenuProvider(be), (BlockPos)pos);
                    PiglinAi.m_34873_((Player)player, (boolean)true);
                } else {
                    EasyText.sendMessage(player, (Component)EasyText.translatable("tooltip.lightmanscurrency.upgrade.coin_chest.protection.warning", new Object[0]).m_130940_(ChatFormatting.GOLD));
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinChestBlockEntity) {
            CoinChestBlockEntity be = (CoinChestBlockEntity)blockEntity;
            if (be.allowAccess(player)) {
                be.onValidBlockRemoval();
            } else {
                return;
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean flag) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinChestBlockEntity) {
            CoinChestBlockEntity be = (CoinChestBlockEntity)blockEntity;
            be.onBlockRemoval();
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)be.getStorage());
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)be.getUpgrades());
        }
        super.m_6810_(state, level, pos, newState, flag);
    }

    @Override
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return Collections.singleton((BlockEntityType)ModBlockEntities.COIN_CHEST.get());
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new CoinChestBlockEntity(pos, state);
    }

    public boolean m_8133_(@Nonnull BlockState p_49226_, @Nonnull Level p_49227_, @Nonnull BlockPos p_49228_, int p_49229_, int p_49230_) {
        super.m_8133_(p_49226_, p_49227_, p_49228_, p_49229_, p_49230_);
        BlockEntity blockentity = p_49227_.m_7702_(p_49228_);
        return blockentity != null && blockentity.m_7531_(p_49229_, p_49230_);
    }

    @Override
    public boolean canBreak(Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinChestBlockEntity) {
            CoinChestBlockEntity blockEntity2 = (CoinChestBlockEntity)blockEntity;
            return blockEntity2.allowAccess(player);
        }
        return true;
    }
}

