/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinJarBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.interfaces.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoinJarBlock
extends RotatableBlock
implements IEasyEntityBlock {
    public CoinJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public CoinJarBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties, shape);
    }

    @Override
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return ImmutableList.of((Object)((BlockEntityType)ModBlockEntities.COIN_JAR.get()));
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new CoinJarBlockEntity(pos, state);
    }

    public void m_6402_(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity player, @Nonnull ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinJarBlockEntity) {
            CoinJarBlockEntity jar = (CoinJarBlockEntity)blockEntity;
            jar.readItemTag(stack);
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        if (!level.f_46443_) {
            CoinJarBlockEntity jar;
            ItemStack coinStack = player.m_21120_(hand);
            if (!MoneyUtil.isCoin(coinStack, false)) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CoinJarBlockEntity && (jar = (CoinJarBlockEntity)blockEntity).addCoin(coinStack)) {
                coinStack.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CoinJarBlockEntity) {
            CoinJarBlockEntity jarEntity = (CoinJarBlockEntity)tileEntity;
            if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44985_, (LivingEntity)player) > 0) {
                ItemStack dropStack = new ItemStack((ItemLike)this, 1);
                jarEntity.writeItemTag(dropStack);
                jarEntity.clearStorage();
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)dropStack);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean flag) {
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, flag);
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinJarBlockEntity) {
            CoinJarBlockEntity jarEntity = (CoinJarBlockEntity)blockEntity;
            jarEntity.getStorage().forEach(coin -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)coin));
            jarEntity.clearStorage();
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinJarBlockEntity) {
            CoinJarBlockEntity jarBlock = (CoinJarBlockEntity)blockEntity;
            if (player.m_7500_() && player.m_6047_()) {
                jarBlock.writeItemTag(stack);
            } else {
                jarBlock.writeSimpleItemTag(stack);
            }
        }
        return stack;
    }
}

