/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.ItemPositionBlockManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.ItemPositionData;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.ITraderBlock;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IItemTraderBlock
extends ITraderBlock {
    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    default public ItemPositionData getItemPositionData() {
        ItemPositionData itemPositionData;
        IItemTraderBlock iItemTraderBlock = this;
        if (iItemTraderBlock instanceof Block) {
            Block b = (Block)iItemTraderBlock;
            itemPositionData = ItemPositionBlockManager.getDataForBlock(b);
        } else {
            itemPositionData = ItemPositionData.EMPTY;
        }
        return itemPositionData;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(since="2.1.2.4")
    default public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isDoubleTrade) {
        return new ArrayList<Vector3f>();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(since="2.1.2.4")
    default public List<Quaternion> GetStackRenderRot(int tradeSlot, BlockState state) {
        return new ArrayList<Quaternion>();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(since="2.1.2.4")
    default public float GetStackRenderScale(int tradeSlot, BlockState state) {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(since="2.1.2.4")
    default public int maxRenderIndex() {
        return 0;
    }
}

