/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.util;

import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.util.TriFunction;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LazyShapes {
    public static final VoxelShape SHORT_BOX = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape SHORT_BOX_T = Block.m_49796_((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)8.0, (double)15.99);
    public static final Function<Direction, VoxelShape> SHORT_BOX_SHAPE = LazyShapes.lazySingleShape(SHORT_BOX);
    public static final Function<Direction, VoxelShape> SHORT_BOX_SHAPE_T = LazyShapes.lazySingleShape(SHORT_BOX_T);
    public static final VoxelShape BOX = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape BOX_T = Block.m_49796_((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)16.0, (double)15.99);
    public static final Function<Direction, VoxelShape> BOX_SHAPE = LazyShapes.lazySingleShape(BOX);
    public static final Function<Direction, VoxelShape> BOX_SHAPE_T = LazyShapes.lazySingleShape(BOX_T);
    public static final VoxelShape TALL_BOX = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    public static final VoxelShape TALL_BOX_T = Block.m_49796_((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)32.0, (double)15.99);
    public static final BiFunction<Direction, Boolean, VoxelShape> TALL_BOX_SHAPE = LazyShapes.lazyTallSingleShape(TALL_BOX);
    public static final BiFunction<Direction, Boolean, VoxelShape> TALL_BOX_SHAPE_T = LazyShapes.lazyTallSingleShape(TALL_BOX_T);
    public static final VoxelShape WIDE_BOX_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0);
    public static final VoxelShape WIDE_BOX_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)32.0);
    public static final VoxelShape WIDE_BOX_SOUTH = Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WIDE_BOX_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)-16.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BiFunction<Direction, Boolean, VoxelShape> WIDE_BOX_SHAPE = LazyShapes.lazyWideDirectionalShape(WIDE_BOX_NORTH, WIDE_BOX_EAST, WIDE_BOX_SOUTH, WIDE_BOX_WEST);
    public static final VoxelShape TALL_WIDE_BOX_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)32.0, (double)32.0, (double)16.0);
    public static final VoxelShape TALL_WIDE_BOX_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)32.0);
    public static final VoxelShape TALL_WIDE_BOX_SOUTH = Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    public static final VoxelShape TALL_WIDE_BOX_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)-16.0, (double)16.0, (double)32.0, (double)16.0);
    public static final VoxelShape TALL_WIDE_BOX_NORTH_T = Block.m_49796_((double)0.01, (double)0.0, (double)0.01, (double)31.99, (double)32.0, (double)15.99);
    public static final VoxelShape TALL_WIDE_BOX_EAST_T = Block.m_49796_((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)32.0, (double)31.99);
    public static final VoxelShape TALL_WIDE_BOX_SOUTH_T = Block.m_49796_((double)-15.99, (double)0.0, (double)0.01, (double)15.99, (double)32.0, (double)15.99);
    public static final VoxelShape TALL_WIDE_BOX_WEST_T = Block.m_49796_((double)0.01, (double)0.0, (double)-15.99, (double)15.99, (double)32.0, (double)15.99);
    public static final TriFunction<Direction, Boolean, Boolean, VoxelShape> TALL_WIDE_BOX_SHAPE = LazyShapes.lazyTallWideDirectionalShape(TALL_WIDE_BOX_NORTH, TALL_WIDE_BOX_EAST, TALL_WIDE_BOX_SOUTH, TALL_WIDE_BOX_WEST);
    public static final TriFunction<Direction, Boolean, Boolean, VoxelShape> TALL_WIDE_BOX_SHAPE_T = LazyShapes.lazyTallWideDirectionalShape(TALL_WIDE_BOX_NORTH_T, TALL_WIDE_BOX_EAST_T, TALL_WIDE_BOX_SOUTH_T, TALL_WIDE_BOX_WEST_T);

    public static Function<Direction, VoxelShape> lazySingleShape(VoxelShape shape) {
        return facing -> shape;
    }

    public static Function<Direction, VoxelShape> lazyDirectionalShape(VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
        return new LazyDirectionShapeHandler(north, east, south, west);
    }

    public static Function<Direction, VoxelShape> lazyDirectionalShape(VoxelShape northSouth, VoxelShape eastWest) {
        return new LazyDirectionShapeHandler(northSouth, eastWest, northSouth, eastWest);
    }

    public static BiFunction<Direction, Boolean, VoxelShape> lazyTallSingleShape(VoxelShape shape) {
        return (facing, isBottom) -> {
            if (isBottom.booleanValue()) {
                return shape;
            }
            return LazyShapes.moveDown(shape);
        };
    }

    public static BiFunction<Direction, Boolean, VoxelShape> lazyTallDirectionalShape(VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
        return new LazyDirectionTallShapeHandler(north, east, south, west);
    }

    public static BiFunction<Direction, Boolean, VoxelShape> lazyWideDirectionalShape(VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
        return new LazyDirectionWideShapeHandler(north, east, south, west);
    }

    public static TriFunction<Direction, Boolean, Boolean, VoxelShape> lazyTallWideDirectionalShape(BiFunction<Direction, Boolean, VoxelShape> tallShape) {
        return new LazyDirectionTallWideShapeHandler(tallShape);
    }

    public static TriFunction<Direction, Boolean, Boolean, VoxelShape> lazyTallWideDirectionalShape(VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
        return new LazyDirectionTallWideShapeHandler(north, east, south, west);
    }

    public static final VoxelShape moveDown(VoxelShape shape) {
        return shape.m_83216_(0.0, -1.0, 0.0);
    }

    protected static class LazyDirectionShapeHandler
    implements Function<Direction, VoxelShape> {
        private final VoxelShape north;
        private final VoxelShape east;
        private final VoxelShape south;
        private final VoxelShape west;

        public LazyDirectionShapeHandler(VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
            this.north = north;
            this.east = east;
            this.south = south;
            this.west = west;
        }

        @Override
        public VoxelShape apply(Direction facing) {
            switch (facing) {
                case EAST: {
                    return this.east;
                }
                case SOUTH: {
                    return this.south;
                }
                case WEST: {
                    return this.west;
                }
            }
            return this.north;
        }
    }

    protected static class LazyDirectionTallShapeHandler
    implements BiFunction<Direction, Boolean, VoxelShape> {
        private final Function<Direction, VoxelShape> lazyShape;

        public LazyDirectionTallShapeHandler(VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
            this.lazyShape = LazyShapes.lazyDirectionalShape(north, east, south, west);
        }

        @Override
        public VoxelShape apply(Direction facing, Boolean isBottom) {
            VoxelShape shape = this.lazyShape.apply(facing);
            if (isBottom.booleanValue()) {
                return shape;
            }
            return LazyShapes.moveDown(shape);
        }
    }

    protected static class LazyDirectionWideShapeHandler
    implements BiFunction<Direction, Boolean, VoxelShape> {
        private final Function<Direction, VoxelShape> lazyShape;

        public LazyDirectionWideShapeHandler(VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
            this.lazyShape = LazyShapes.lazyDirectionalShape(north, east, south, west);
        }

        @Override
        public VoxelShape apply(Direction facing, Boolean isLeft) {
            VoxelShape shape = this.lazyShape.apply(facing);
            if (isLeft.booleanValue()) {
                return shape;
            }
            Vector3f offset = IRotatableBlock.getLeftVect(facing);
            return shape.m_83216_((double)offset.m_122239_(), (double)offset.m_122260_(), (double)offset.m_122269_());
        }
    }

    protected static class LazyDirectionTallWideShapeHandler
    implements TriFunction<Direction, Boolean, Boolean, VoxelShape> {
        private final BiFunction<Direction, Boolean, VoxelShape> lazyShape;

        public LazyDirectionTallWideShapeHandler(BiFunction<Direction, Boolean, VoxelShape> tallShape) {
            this.lazyShape = tallShape;
        }

        public LazyDirectionTallWideShapeHandler(VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
            this.lazyShape = LazyShapes.lazyTallDirectionalShape(north, east, south, west);
        }

        @Override
        public VoxelShape apply(Direction facing, Boolean isBottom, Boolean isLeft) {
            VoxelShape shape = this.lazyShape.apply(facing, isBottom);
            if (isLeft.booleanValue()) {
                return shape;
            }
            Vector3f offset = IRotatableBlock.getLeftVect(facing);
            return shape.m_83216_((double)offset.m_122239_(), (double)offset.m_122260_(), (double)offset.m_122269_());
        }
    }
}

