/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.capability;

import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.ISpawnTracker;
import io.github.lightman314.lightmanscurrency.common.loot.LootManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SpawnTrackerCapability {
    @Deprecated
    public static LazyOptional<ISpawnTracker> getSpawnerTracker(@Nonnull LivingEntity entity) {
        return entity.getCapability(CurrencyCapabilities.SPAWN_TRACKER);
    }

    @Nullable
    public static ISpawnTracker lazyGetSpawnerTracker(@Nonnull LivingEntity entity) {
        LazyOptional optional = entity.getCapability(CurrencyCapabilities.SPAWN_TRACKER);
        if (optional.isPresent()) {
            return (ISpawnTracker)optional.orElseThrow(() -> new RuntimeException("Unexpected error occurred!"));
        }
        return null;
    }

    public static ICapabilityProvider createProvider(LivingEntity livingEntity) {
        return new Provider(livingEntity);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<ISpawnTracker> optional;
        final ISpawnTracker handler;

        Provider(LivingEntity entity) {
            this.handler = new SpawnTracker(entity);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return CurrencyCapabilities.SPAWN_TRACKER.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            return this.handler.save();
        }

        public void deserializeNBT(Tag tag) {
            if (tag instanceof CompoundTag) {
                this.handler.load((CompoundTag)tag);
            }
        }
    }

    public static class SpawnTracker
    implements ISpawnTracker {
        final LivingEntity entity;
        MobSpawnType reason = MobSpawnType.NATURAL;

        public SpawnTracker(LivingEntity entity) {
            this.entity = entity;
        }

        @Override
        public MobSpawnType spawnReason() {
            return this.reason;
        }

        @Override
        public void setSpawnReason(MobSpawnType reason) {
            this.reason = reason;
        }

        @Override
        public CompoundTag save() {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("SpawnReason", this.reason.toString());
            return compound;
        }

        @Override
        public void load(CompoundTag compound) {
            if (compound.m_128425_("SpawnReason", 8)) {
                this.reason = LootManager.deserializeSpawnReason(compound.m_128461_("SpawnReason"));
            }
        }
    }
}

