/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.TraderArgument;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.network.message.command.SPacketDebugTrader;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CommandLCAdmin {
    private static final SimpleCommandExceptionType ERROR_BLOCK_NOT_FOUND = new SimpleCommandExceptionType((Message)EasyText.translatable("command.trader.block.notfound", new Object[0]));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcadmin").requires(stack -> stack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggleadmin").requires(stack -> stack.m_81373_() instanceof ServerPlayer)).executes(CommandLCAdmin::toggleAdmin))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"traderdata").then(Commands.m_82127_((String)"list").executes(CommandLCAdmin::listTraderData))).then(Commands.m_82127_((String)"search").then(Commands.m_82129_((String)"searchText", (ArgumentType)MessageArgument.m_96832_()).executes(CommandLCAdmin::searchTraderData)))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"traderID", (ArgumentType)TraderArgument.trader()).executes(CommandLCAdmin::deleteTraderData)))).then(Commands.m_82127_((String)"debug").then(Commands.m_82129_((String)"traderID", (ArgumentType)TraderArgument.trader()).executes(CommandLCAdmin::debugTraderData)))).then(Commands.m_82127_((String)"addToWhitelist").then(Commands.m_82129_((String)"traderID", (ArgumentType)TraderArgument.traderWithPersistent()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(CommandLCAdmin::addToTraderWhitelist)))))).then(Commands.m_82127_((String)"prepareForStructure").then(Commands.m_82129_((String)"traderPos", (ArgumentType)BlockPosArgument.m_118239_()).executes(CommandLCAdmin::setCustomTrader)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"replaceWallet").requires(c -> !LightmansCurrency.isCuriosLoaded())).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"wallet", (ArgumentType)ItemArgument.m_120960_()).executes(CommandLCAdmin::replaceWalletSlotWithDefault)).then(Commands.m_82129_((String)"keepWalletContents", (ArgumentType)BoolArgumentType.bool()).executes(CommandLCAdmin::replaceWalletSlot)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"taxes").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"openServerTax").requires(stack -> stack.m_81373_() instanceof ServerPlayer)).executes(CommandLCAdmin::openServerTax))).then(Commands.m_82127_((String)"forceDisableTaxCollectors").executes(CommandLCAdmin::forceDisableTaxCollectors)));
        dispatcher.register(lcAdminCommand);
    }

    static int toggleAdmin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer sourcePlayer = source.m_81375_();
        LCAdminMode.ToggleAdminPlayer(sourcePlayer);
        MutableComponent enabledDisabled = LCAdminMode.isAdminPlayer((Player)sourcePlayer) ? EasyText.translatable("command.lightmanscurrency.lcadmin.toggleadmin.enabled", new Object[0]).m_130940_(ChatFormatting.GREEN) : EasyText.translatable("command.lightmanscurrency.lcadmin.toggleadmin.disabled", new Object[0]).m_130940_(ChatFormatting.RED);
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.toggleadmin", enabledDisabled), true);
        return 1;
    }

    static int setCustomTrader(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        BlockPos pos = BlockPosArgument.m_118242_(commandContext, (String)"traderPos");
        ServerLevel level = source.m_81372_();
        BlockState state = level.m_8055_(pos);
        BlockEntity be = state.m_60734_() instanceof ITraderBlock ? ((ITraderBlock)state.m_60734_()).getBlockEntity(state, (LevelAccessor)level, pos) : level.m_7702_(pos);
        if (be instanceof TraderBlockEntity) {
            TraderBlockEntity t = (TraderBlockEntity)be;
            t.saveCurrentTraderAsCustomTrader();
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.setCustomTrader.success", new Object[0]), true);
            return 1;
        }
        throw ERROR_BLOCK_NOT_FOUND.create();
    }

    static int listTraderData(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        List<TraderData> allTraders = TraderSaveData.GetAllTraders(false);
        if (allTraders.size() > 0) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.title", new Object[0]), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                TraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    EasyText.sendCommandSucess(source, (Component)EasyText.empty(), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.none", new Object[0]), true);
        }
        return 1;
    }

    static int searchTraderData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        String searchText = MessageArgument.m_96835_(commandContext, (String)"searchText").getString();
        List<TraderData> results = TraderSaveData.GetAllTraders(false).stream().filter(trader -> TraderSearchFilter.CheckFilters(trader, searchText)).toList();
        if (results.size() > 0) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.title", new Object[0]), true);
            for (int i = 0; i < results.size(); ++i) {
                TraderData thisTrader = results.get(i);
                if (i > 0) {
                    EasyText.sendCommandSucess(source, (Component)EasyText.empty(), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.search.none", new Object[0]), true);
        }
        return 1;
    }

    private static void sendTraderDataFeedback(TraderData thisTrader, CommandSourceStack source) {
        String traderID = String.valueOf(thisTrader.getID());
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.traderid", EasyText.translatable(traderID, new Object[0]).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, traderID)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.traderid.copytooltip", new Object[0]))))), false);
        if (thisTrader.isPersistent()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.persistentid", thisTrader.getPersistentID()), false);
        }
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.type", thisTrader.type), false);
        if (thisTrader instanceof AuctionHouseTrader) {
            return;
        }
        if (thisTrader.getOwner().hasTeam()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.owner.team", thisTrader.getOwner().getTeam().getName(), thisTrader.getOwner().getTeam().getID()), false);
        } else if (thisTrader.getOwner().hasPlayer()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.owner", thisTrader.getOwner().getPlayer().getName(false), thisTrader.getOwner().getPlayer().id.toString()), false);
        } else {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.owner.custom", thisTrader.getOwner().getOwnerName(false)), false);
        }
        if (!thisTrader.isPersistent()) {
            String dimension = thisTrader.getLevel().m_135782_().toString();
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.dimension", dimension), false);
            BlockPos pos = thisTrader.getPos();
            String position = pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
            String teleportPosition = pos.m_123341_() + " " + (pos.m_123342_() + 1) + " " + pos.m_123343_();
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.position", EasyText.literal(position).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/execute in " + dimension + " run tp @s " + teleportPosition)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.position.teleporttooltip", new Object[0]))))), true);
        }
        if (thisTrader.hasCustomName()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.name", thisTrader.getName()), true);
        }
    }

    static int deleteTraderData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Entity entity;
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        TraderSaveData.DeleteTrader(trader.getID());
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.delete.success", trader.getName()), true);
        if (source.m_81373_() != null && (entity = source.m_81373_()) instanceof Player) {
            Player player = (Player)entity;
            new SPacketDebugTrader(trader.getID()).sendTo(player);
        }
        return 1;
    }

    static int debugTraderData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        EasyText.sendCommandSucess(source, (Component)EasyText.literal(trader.save().m_7916_()), false);
        return 1;
    }

    static int addToTraderWhitelist(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        TradeRule rule = TradeRule.getRule(PlayerWhitelist.TYPE, trader.getRules());
        if (rule instanceof PlayerWhitelist) {
            PlayerWhitelist whitelist = (PlayerWhitelist)rule;
            Collection players = EntityArgument.m_91477_(commandContext, (String)"player");
            int count = 0;
            for (ServerPlayer player : players) {
                if (!whitelist.addToWhitelist((Player)player)) continue;
                ++count;
            }
            int c = count;
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.traderdata.add_whitelist.success", c, trader.getName()), true);
            if (count > 0) {
                trader.markTradeRulesDirty();
            }
            return count;
        }
        EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.traderdata.add_whitelist.missingrule", new Object[0]));
        return 0;
    }

    static int replaceWalletSlotWithDefault(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        return CommandLCAdmin.replaceWalletSlotInternal(commandContext, true);
    }

    static int replaceWalletSlot(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        return CommandLCAdmin.replaceWalletSlotInternal(commandContext, BoolArgumentType.getBool(commandContext, (String)"keepWalletContents"));
    }

    static int replaceWalletSlotInternal(CommandContext<CommandSourceStack> commandContext, boolean keepWalletContents) throws CommandSyntaxException {
        int count = 0;
        ItemInput input = ItemArgument.m_120963_(commandContext, (String)"wallet");
        if (!(input.m_120979_() instanceof WalletItem) && input.m_120979_() != Items.f_41852_) {
            throw new CommandSyntaxException(new CommandExceptionType(){}, (Message)EasyText.translatable("command.lightmanscurrency.lcadmin.replaceWalletSlot.notawallet", new Object[0]));
        }
        for (Entity entity : EntityArgument.m_91461_(commandContext, (String)"entity")) {
            ItemStack oldWallet;
            ItemStack newWallet;
            IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler(entity);
            if (walletHandler == null || (newWallet = input.m_120980_(1, true)).m_41619_() && walletHandler.getWallet().m_41619_()) continue;
            if (keepWalletContents && WalletItem.isWallet(oldWallet = walletHandler.getWallet())) {
                WalletItem.CopyWalletContents(oldWallet, newWallet);
            }
            walletHandler.setWallet(newWallet);
        }
        return count;
    }

    static int openServerTax(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        TaxEntry entry = TaxSaveData.GetServerTaxEntry(false);
        if (entry != null) {
            entry.openMenu((Player)((CommandSourceStack)commandContext.getSource()).m_81375_(), SimpleValidator.NULL);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.openServerTax.error", new Object[0]));
        return 0;
    }

    static int forceDisableTaxCollectors(CommandContext<CommandSourceStack> commandContext) {
        int count = 0;
        for (TaxEntry entry : TaxSaveData.GetAllTaxEntries(false)) {
            if (!entry.isActive()) continue;
            entry.setActive(false, null);
            ++count;
        }
        if (count > 0) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.forceDisableTaxCollectors.success", count), true);
        } else {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.forceDisableTaxCollectors.fail", new Object[0]));
        }
        return count;
    }

    @Deprecated(since="2.1.2.4")
    public static boolean isAdminPlayer(@Nullable Player player) {
        return LCAdminMode.isAdminPlayer(player);
    }
}

