/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.playertrading.PlayerTrade;
import io.github.lightman314.lightmanscurrency.common.playertrading.PlayerTradeManager;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class TradeIDArgument
implements ArgumentType<Integer> {
    private static final SimpleCommandExceptionType ERROR_NOT_VALID = new SimpleCommandExceptionType((Message)EasyText.translatable("command.argument.tradeid.invalid", new Object[0]));

    private TradeIDArgument() {
    }

    public static TradeIDArgument argument() {
        return new TradeIDArgument();
    }

    public static int getTradeID(CommandContext<CommandSourceStack> commandContext, String name) {
        return (Integer)commandContext.getArgument(name, Integer.class);
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        String tradeID = reader.readUnquotedString();
        if (TradeIDArgument.isNumerical(tradeID)) {
            try {
                return Integer.parseInt(tradeID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw ERROR_NOT_VALID.createWithContext((ImmutableStringReader)reader);
    }

    private static boolean isNumerical(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        Object object = commandContext.getSource();
        if (object instanceof CommandSourceStack) {
            CommandSourceStack source = (CommandSourceStack)object;
            Entity e = source.m_81373_();
            if (!(e instanceof ServerPlayer)) {
                return suggestionsBuilder.buildFuture();
            }
            ServerPlayer player = (ServerPlayer)e;
            for (PlayerTrade trade : PlayerTradeManager.GetAllTrades()) {
                if (!trade.isGuest((Player)player)) continue;
                suggestionsBuilder.suggest(trade.tradeID);
            }
        }
        return suggestionsBuilder.buildFuture();
    }
}

